IPROUTE.SYS(8)          XROUTER REFERENCE MANUAL            17/10/2023

NAME
        IPROUTE.SYS -- IP Router Configuration File (optional).

DESCRIPTION
        This optional file is only required if you wish to route IP
        traffic, or use any of XRouter's IP facilities such as Telnet,
        Ping, Traceroute, HTTP server etc. I.e. it is not required
        if you are operating a pure AX25 / Netrom system, although
        you are urged to route amateur IP if possible.

        The file is read only at boot-up, or by an "IP ROUTE LOAD"
        command so if you make changes to it, they won't take
        effect until you reboot or use that command.  XRouter does
        not write to this file.

        If IPROUTE.SYS is present, it saves you having to enter
        the IP routing manually.  To reduce the number of
        configuration files, this file also contains the permanent
        ARP (Address Resolution Protocol), NAT (Network Address
        Translation), RIP (Routing Information Protocol) entries,
        and IP filtering rules.

FILE FORMAT
        IPROUTE.SYS is a text file. Within the file, each entry
        must be on a separate line, and there must be one or more
        spaces or tabs between each field.  Entries are not case
        sensitive.  Comments are allowed, providing they are on a
        line beginning with a semicolon ';' or hash '#'. Blank
        lines are ignored and lines may be up to 255 characters
        long.

        Commands accepted in this file are as follows:
       
            ACL <PERMIT | DENY>
            ARP <ADD | PUBLISH>
            DUN <ADD | LOG>
            IP <CMD | ROUTE ADD | ROUTE DEFAULT | QUIET | TTL>
            NAT <ADD>
            RIP <ADD | LEARN | REFUSE | TIMEOUT>

        ACL commands control the Access Control List, which
            specifies the IP addresses which are allowed to access
            and be accessed by XRouter.

        ARP commands are used to add "static" entries to the ARP
            table. These are mainly used for slow RF links.

        DUN commands are used to configure "dial-up" routing.

        IP  commands are used to add routes to the IP routing table
            and to configure the TTL, stealth level, and
            availability of the IPROUTE command.

        NAT commands add Network Address Translation entries to the
            NAT table.

        RIP commands control the RIP98 and RIP2 automatic route
            learning system.

        All of these commands are described in more detail in their
        own section 1 MAN pages (see below).

FILES
        If present, IPROUTE.SYS must be located in the same
        directory as the XRouter executable.

SEE ALSO
        ACL(1)       -- IP Access Control List Commands.
        ARP(1)       -- Address Resolution Protocol Commands.
        DUN(1)       -- Dial-up Networking Commands.
        IP(1)        -- IP Routing / Configuration Commands.
        IP-PRIMER(9) -- IP Addressing / Routing Primer.
        IPROUTE(1)   -- Display IP Routes
        NAT(1)       -- Network Address Translation Commands.
        RIP(1)       -- Routing Interface Protocol Commands.

IPROUTE.SYS(8)              END OF DOCUMENT
