IPUDP-FAQ(9)            XROUTER REFERENCE MANUAL            21/10/2023

NAME
        IPUDP-FAQ -- IPUDP FAQ / Troubleshooting.

DESCRIPTION
        This document contains Frequently Asked Questions and
        troubleshooting information related to the IPUDP protocol.
        It is a work in progress...


        IPUDP Frequently Asked Questions
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        Q) Under what circumstances should I use IPUDP?

           A) You might consider using IPUDP in the following
              situations: 

           - When you cannot use IPEncap because are running XRouter
             on Windows without the NdisXpkt driver. 

           - When your Internet router cannot handle "portless"
             protocols such as IPIP, IPEncap, AXIP etc. 

           - When you have an existing system that requires your
             Internet router to route IPENCAP to it (you can only
             have one IPENCAP host per public IP address). 

           - When you have more than one system on the same public
             IP address and require independent routing to each. 

           - When you have more than one XRouter on the same machine,
             with different 44-net addresses. 

           - When you wish to route between 44-net systems on your
             LAN that can't use IPEncap. 

           - Just for the fun of it! :-) 


        Q) Can I Send IPUDP To Anyone? 

           A) No. It is believed that IPUDP is only implemented by
              XRouter at the time of writing.


        Q) If I use IPUDP, can I still use other forms of IP routing? 

           A) Yes. You can safely "mix and match" your IP routing
              modes to suit your own requirements.  What you mustn't
              do is have identical route table entries with different
              modes.  Nothing dangerous will happen, but XRouter will
              ignore the duplicates. 


        Q) Do I need an AXIP interface to use IPUDP?

           A) No. IPDUP is completely unrelated to AX25, AXIP, AXUDP
              etc. and does not need a special INTERFACE or PORT. 


        Q) Do I need ENCAP.TXT?

           A) No, not for IPUDP itself, but you may need it if you
              intend to use IPEncap alongside IPUDP.

              There is an XRouter-only version of ENCAP.TXT called
              XENCAP.TXT, which can accept routing modes other than
              "encap".  Place it into your XRouter working directory
              and type IP ROUTE LOAD to read it into your routing
              table.

              If you wish to add your system(s) to the list so that
              they can receive IPUDP traffic, please email
              g8pzt[at]blueyonder.co.uk, stating your callsign, the
              subnet address(s) that you handle, your public IP
              address, and your IPUDP port number if it isn't 94. 


        Troubleshooting
        ~~~~~~~~~~~~~~~

        IPUDP is a well-proven technology.  When things don't work,
        it is always due to a configuration error, not a fault in
        XRouter.

        Try PINGing the destination host to see if XRouter generates
        an error message. Some of the errors so far observed are
        listed below: 

        o Boot up error: "IPUDP Initialisation error 20048" 

          The IPUDP port is already in use by another process on the
          PC.  This error is usually caused by trying to run more
          than one XRouter on the same machine.  You must use the
          IPUDPPORT keyword in XROUTER.CFG to disable IPUDP on all
          but one XRouter, or to assign a different port number to
          each one. 


        o Error 9x02 (No memory)
 
          This should never happen, but if it does, Windows must be
          seriously overloaded!  This is a transient error, and
          should clear itself.  If not, close some apps.


        o Error 9206 (Permission denied)
 
          The IP Access Control List is preventing the packet from
          being sent because the combination of source and
          destination IP addresses is not within one of the ranges
          you have defined to be "legal".  Possible causes are: 

          - XRouter's "main" IP address not defined, or is not a
            44-net address.
 
          - Incorrect configuration of IP Access Control List.
            Try commenting out all the ACL entries in IPROUTE.SYS and
            reloading the file.  If this fixes the problem, there is
            a faulty of missing entry.  You may need to add the
            following entry: ACL PERMIT  0.0.0.0/32  0.0.0.0/0


        o Error 9411 

          The IPUDP subsystem was not initialised because the main IP
          address was not defined, or because IPUDPORT is set to 0 in
          XROUTER.CFG. 


        o No Response From Target

          Assuming you have set up the route entry correctly, there
          are many possible reasons for failure.  The following list
          is by no means exhaustive: 

          - Your system has no viable route to the target's public
            IP address.  Try PINGing or Telnetting to that address.
            Note that if IP QUIET or firewalling is active, you may
            not get a reply to your PINGs.

          - There is a higher priority but non-functional route in
            the IP routing table, preventing the IPUDP route from
            being used.

          - There's a problem with your or your partner's Internet
            connection.
 
          - The target system is currently off-line for maintenance.

          - The target's sysop has disabled IPUDP, or has reassigned
            the IPUDPPORT.
 
          - The target's Internet router is not set up to route IPUDP
            to his XRouter, or the response is via IPUDP and your
            Internet router is not set up to route it to your
            XRouter.
 
          - The target's IP addresses are set up incorrectly.
 
          - The target hasn't configured a route that leads back to
            you. Note that he doesn't need to configure a *direct*
            route back to you, he may send it via other routers or
            gateways.

          - An intermediate router is dropping the return packets.

          - The response is IPUDP and the target is replying to the
            wrong UDP port number.
 
          - The response is via IPEncap and your Internet router is
            not set up to route it, or your system is not using
            NdisXpkt (Windows only), and can therefore not accept
            IPEncap. 

SEE ALSO
        IP(1)          -- IP Routing / Configuration Commands.
        IPENCAP(9)     -- IPENCAP Protocol.
        IPIP(9)        -- IPIP Protocol.
        IPROUTE.SYS(8) -- IP Routing / Configuration File.
        IPUDP(9)       -- IP-within-UDP Encapsulation.
        NDISXPKT(9)    -- NDISXPKT Driver (Windows Only).
        XROUTER.CFG(8) -- Main Configuration File.

IPUDP-FAQ(9)              END OF DOCUMENT

