IPUDP(9)                XROUTER REFERENCE MANUAL            17/10/2023

NAME
        IPUDP -- IP-over-UDP Tunnelling.

DESCRIPTION
        The "Amateur Packet Radio IP Network" (amprnet) is a private
        network for transferring TCP/IP between amateur radio
        stations.  It was originally assigned the class A IP address
        block 44.x.x.x, but although it is notionally part of the
        wider Internet, the public Internet has limited knowledge of
        how to route it.

        To solve this problem, amprnet traffic is usually wrapped or
        "encapsulated" within publicly-routable IP datagrams.  At the
        destination gateway the frame is "unwrapped" to reveal the
        original amprnet datagram. 

        IPUDP is IP encapsulated in UDP/IP.  It allows amateur IP to
        be transported across other IP networks such as the Internet,
        to form "Virtual Private Networks" (VPN's).

        In contrast to IPIP and IPEncap, which transport the private
        (e.g. amateur) IP directly inside the payload portion of a
        public (e.g. Internet) IP datagram, IPUDP transports the
        private datagram in the payload portion of a UDP frame, which
        is itself transported as payload in a public IP datagram.
        This requires 8 bytes more overhead than IPIP, but it is far
        more flexible. 


            .------------------.----------------------------------.
            | Public IP header | UDP Header | Amprnet IP datagram |
            | 62.31.20.2       |   94->94   |   44.131.91.2       |
            | -> 82.31.65.8    |            |   ->44.68.1.5       |
            '------------------'------------'---------------------'
             <---------------- Public IP datagram --------------->

                           IPUDP Packet Structure

           (In the above diagram, the amprnet (44-net) datagram
              forms the payload of a publicly-routable UDP/IP
              datagram. The IP addresses are for illustrative
                             purposes only.) 


        IPIP and IPENCAP, hereafter collectively referred to as
        IP-in-IP, are "portless" protocols, and it is therefore
        difficult (in come cases impossible) to make them pass
        through some types of domestic NAT / PAT router which rely on
        translating TCP and UDP service port numbers in order to
        share a public IP address among several LAN hosts. 

        IPUDP overcomes this limitation because it transports the data
        using a well known protocol (UDP) which NAT / PAT routers can
        understand, thus it can get through where IP-in-IP cannot.
        For example, it is easy to configure even the most basic
        domestic router to route incoming UDP port 94 to a specific
        machine on the LAN, but it is not often possible to do the
        same with IP *protocol* 4. 

        The IPUDP protocol currently defaults to UDP port 94 for no
        better reason than because the number was easy to remember,
        being the same as the original protocol number for IPIP.  In
        addition, there were no other well-known protocols using this
        port number.  If difficulties are encountered with port 94,
        please inform the protocol originator (G8PZT). There's nothing
        to stop you using any other UDP port number.

        IPUDP is only used for tunnelling amateur IP through the
        public Internet, or for situations where conventional routing
        isn't possible (e.g. XR32 without NdisXpkt).  It would be
        pointless when routing via a radio link. 

        IPUDP tunnels are one-way.  To create two-way IPUDP routing,
        the other end of a link needs to set up a reverse tunnel.
        However, the reverse route needn't necessarily use a tunnel. 


        When To Use IPUDP
        ~~~~~~~~~~~~~~~~~

        If you are running a Linux version of XRouter, most of this
        following section may be ignored, and you can jump to the
        final two paragraphs...
 
        The Windows version of XRouter (XR32) was originally designed
        to be used with the NdisXpkt driver, which allowed it to have
        its own LAN IP address and IP stack.  In this mode it could
        route anything, just like its DOS predecessor (XR16). 

        However, there is no 64-bit version of the NdisXpkt driver,
        so XR32 was subsequently made "dual-mode", such that it could
        be made to run with or without the driver. 

        Without the NdisXpkt driver, XR32 was forced to use facilities
        provided by the Windows TCP/IP stack.  Those facilities were
        limited, and in some cases were deliberately crippled by
        Microsoft.  For example, later versions of Windows XP prevent
        the use of IPENCAP (protocol number 4). 

        Since no-one likes having to install and load drivers, the
        majority of sysops now tend to use XR32 without NdisXpkt.
        However this is a "basic" mode, with limited facilities,
        compared to the "full" (NdisXpkt) mode. It was only intended
        as a stop-gap measure, until a 64-bit driver could be written. 

        In basic mode, XR32 can originate and terminate all the common
        protocols (TCP, UDP, ICMP etc.), but cannot actually route raw
        IP via the *Ethernet* NIC without some form of encapsulation.
        (SLIP / PPP connections are not restricted in this way)

        As mentioned above, XR32 in "basic" mode cannot currently use
        the IPENCAP protocol, so your options for routing IP via an
        Ethernet NIC are limited to the following: 

        a) Route IP across existing AXUDP/AXIP links.

           This is the least efficient in terms of packet overhead,
           although that is of litle concern on a broadband
           connection!  It is easy to set up, but the downside is that
           you can only route traffic to your immediate AXUDP or AXIP
           neighbours, not the wider world. However, if everyone sets
           up their default routes to direct the traffic to and from
           an IPENCAP-capable gateway, this should be no barrier. 


        b) Use original IPIP protocol (protocol number 94).
 
           This is the most efficient, and allows you to make a single
           hop (as far as 44-net is concerned) tunnel to *any*
           gateway that can accept IPIP protocol 94.  In order to
           receive this protocol however, your Internet router must be
           capable of routing by PROTOCOL, which many routers aren't.
           This protocol doesn't involve AX25 at all. 


        c) Use IPUDP protocol.

           This option also allows you to hop directly to any other
           gateway, providing they can handle IPUDP, and it doesn't
           use AX25.  It is only marginally less efficient than IPIP,
           and as mentioned previously, it has the advantage that it
           is easy to route through NAT/PAT routers. 


        Although DOS and Linux versions of XRouter (and XR32 in
        "full" mode) allow IPEncap, you cannot use IPEncap if your
        Internet router can't handle it.  In this case, IPUDP may be
        the preferable option.

        Even if your domestic Internet router can handle the IP-in-IP
        protocols (4 and 94), it can only route such traffic to ONE
        host on the LAN. But it can route IPUDP to multiple hosts, if
        different UDP port numbers are used.


        Creating An IPUDP Tunnel
        ~~~~~~~~~~~~~~~~~~~~~~~~

        (Note: For the purposes of this guide it is assumed that your
        connection to the Internet is via a domestic NAT/PAT router
        with firewall.) 

        The following may sound obvious, but in order to create any
        form of tunnel between amprnet hosts, each host needs both an
        amprnet (44.x.x.x.) and a public (e.g. 62.x.x.x) address.  You
        MUST ensure that your amprnet IP address is specified as
        XRouter's "main" address, by including the line
        IPADDRESS=44.x.x.x near the top of the XROUTER.CFG file
        (replacing x.x.x with your IP address). 

        If you are using the EXTERNAL interface (which allows XRouter
        to use its own IP stack), you then "override" this IP address
        on the Ethernet port, by including an IPADDRESS= statement in
        the Ethernet PORT block.  The IP adress should be approriate
        for your LAN.  If you are not using the EXTERNAL interface,
        Windows or Linux provides the LAN IP address instead. 

        Secondly, you and your link partner(s) must set up and test IP
        routing between your public (i.e. non-44.x.x.x) IP addresses.
        You cannot proceed until this step is complete! 

        If you are using a domestic router between XRouter and the
        Internet, you must "open" UDP port 94 to direct incoming IPUDP
        traffic to XRouter's LAN address. This must be a "static"
        (permanent and unchanging) translation, not a transient or
        "port triggered" one. 

        Finally, for each tunnel destination you must add an IP route
        entry into IPROUTE.SYS, similar to the following: 

            IP ROUTE ADD  44.131.91.0/24    62.31.206.176  0   u


        The first IP address is the amateur IP address, or range
        thereof, to be routed via this IPUDP tunnel.  If you don't
        fully understand this format, see the manual sections
        detailing IPROUTE.SYS and the IP ROUTE ADD command. 

        The second address is the public IP address or hostname of the
        link partner to whom the first address(es) will be routed.  It
        is more efficient to use an IP address if possible, rather
        than a hostname, but the hostname may be required if the
        partner's public IP address changes frequently. (DO NOT put
        the partner's 44-net address in here!) 

        The last but one field (which is normally an XRouter PORT
        number in normal route entries) is used in IPUDP entries to
        modify the UDP service number.  "0" is the recommended
        setting, meaning "use default" (see below). 

        Mode "u" signifies IPUDP encapsulation. 


        Reassigning the IPUDP Port Number
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 
        Since you can only have one application using a given UDP port
        number per IP stack, you are not able to run more than one
        copy of XRouter on the same machine unless you reassign or
        disable the IPUDP ports to avoid contention.  You may do this
        using the IPUDPPORT=n keyword anywhere in XROUTER.CFG, where
        n is a number between 0 and 65535. 

        It is recommended that you use port 94 (the default) as the
        primary port, 95 as the first alternative, 96 for the second,
        97 for the third, and so on, as these numbers are not assigned
        to any particular service.  You should avoid using the numbers
        associated with standard services such as DNS (53), DHCP (67
        and 68), AXUDP (93), WINS (135) and so on.  For a
        comprehensive list search for "assigned numbers" on the web.

        Please bear in mind that if you reassign your IPUDP port,
        others will not be able to route IPUDP to you unless you
        inform them of the new number. 


        Routing to Alternative UDP port
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        Creating an IPUDP tunnel to a peer who has reassigned his
        IPUDP port is relatively simple, as the following example
        shows: 

            IP ROUTE ADD  44.131.91.0/24   62.31.206.176  95   u

        Note the "95" in the last but one field, which tells XRouter
        to address the packets to UDP port 95 instead of the default
        port 94.  That's all there is to it! 


        Disabling IPUDP
        ~~~~~~~~~~~~~~~ 

        If you are using XRouter for AX25/Netrom only, and don't wish
        to take part in the amprnet, then you probably won't have
        included an IPADDRESS= line in XROUTER.CFG.  In this case all
        IP facilities, including IPUDP, are disabled automatically.

        However, you may have an IP address but wish to disable IPUDP
        for other reasons. You can do this easily by including the
        directive "IPUDPPORT=0", anywhere in XROUTER.CFG.


        More Info
        ~~~~~~~~~

        This file is too big already. For FAQ and troubleshooting
        info, please see the MAN page entitled IPUDP-FAQ.

SEE ALSO
        IP(1)          -- IP Routing / Configuration Commands.
        IPENCAP(9)     -- IPENCAP Protocol.
        IPIP(9)        -- IPIP Protocol.
        IPROUTE.SYS(8) -- IP Routing / Configuration File.
        IPUDP(9)       -- IP-within-UDP Encapsulation.
        IPUDP-FAQ(9)   -- IPUDP Frequently Asked Questions.
        NDISXPKT(9)    -- NDISXPKT Driver.
        XROUTER.CFG(8) -- Main Configuration File.

IPUDP(9)                    END OF DOCUMENT
