KISS(9)                 XROUTER REFERENCE MANUAL            17/10/2023

NAME
        KISS -- KISS Protocol.

DESCRIPTION
        KISS (Keep It Simple, Stupid) is a simple protocol which
        encapsulates AX25 frames for transmission over serial (e.g.
        RS232) lines.  The framing method is identical to SLIP.
        There is no flow control or error handling in the original
        protocol.

        The protocol specifies the following special characters:

                Name  Hex   Dec  Purpose
                ---------------------------
                FEND  0xC0  192  Frame End
                FESC  0xDB  219  Frame Escape
                TFEND 0xDC  220  Transposed FEND
                TFESC 0xDD  221  Transposed FESC

        The FEND characters mark the start and end of the frame
        containing the encapsulated datagram as follows:

                .------.------.-------.------.
                | FEND | Type | Data  | FEND |
                '------'------'-------'------'

        In order to ensure that the FEND character only occurs at the
        start and end of the frame, FENDs which occur within the
        unencapsulated data are "escaped" to the two byte sequence
        FESC TFEND. Likewise FESC is escaped to the sequence
        FESC TFESC.

        It is permissible (but not obligatorry) for two frames to
        share a FEND:

                .------.------.-------.------.------.-------.------.
                | FEND | Type | Data  | FEND | Type | Data  | FEND |
                '------'------'-------'------'------'-------'------'
              

        The first byte of each frame, after the FEND, is a "type"
        indicator.  This byte is broken into two 4-bit nibbles such
        that the low-order nibble indicates the command number (given
        in the table below) and the high-order nibble indicates the
        port number for that particular command.  In systems with
        only one HDLC port, it is by definition Port 0.  In
        multi-port TNCs, the upper 4 bits of the type indicator byte
        can specify one of up to sixteen ports.

        The following commands are defined:

        Command  Function    Comments
        -------------------------------------------------------------- 
           0     Data frame  The rest of the frame is data received
                             from / to be sent to the HDLC channel.   

           1     TXDELAY     The next byte is the transmitter keyup
                             delay in 10 ms units.  The default
                             start-up value is 50 (i.e. 500 ms). 

           2     PERSIST     The next byte is the persistence
                             parameter, p, scaled to the range 0-255
                             with the following formula: P=p*256-1
                             The default value is P=63 (i.e. p=0.25).  
 
           3     SLOTTIME    The next byte is the slot interval in 10
                             ms units. The default is 10 (i.e. 100ms). 

           4     TXTAIL      The next byte is the time to hold up the
                             TX after the FCS has been sent, in 10 ms
                             units.  This command is obsolete, and is
                             included here only for compatibility
                             with some existing implementations.  
 
           5     FULLDUP     The next byte is 0 for half-duplex,
                             nonzero for full-duplex. The default is 0
                             (i.e. half-duplex).  

           6     SetH/w      Specific for each TNC.  In the TNC-1,
                             this command sets the modem speed.  Other
                             implementations may use this function for
                             other hardware-specific functions.  
    
          255    Return      Exit KISS and return control to a higher
                             level program.  This is useful only when
                             KISS is incorporated into the TNC along
                             with other applications.  
        --------------------------------------------------------------

        Only command 0 is allowed in frames from TNC to host.
        Commands 1 to 6 are used to set TNC parameters, and are
        usually sent at 5 minute intervals.


        Limitations Of Plain KISS
        ~~~~~~~~~~~~~~~~~~~~~~~~~

        In the original protocol, there is no error detection to
        protect against noise and corruption on the RS232 lines.

        More seriously, the host has no way of knowing how much data
        is queued in the TNC awaiting transmission. A busy channel
        could prevent the TNC from transmitting, causing the host's
        FRACK timer to repeat frames, which simply add to the queue.
        When the channel clears, the original frame and all the
        repeats are spewed out in one huge transmission, causing the
        other end of the link to respond with a load of acks.  In bad
        cases, the AX25 module retries out, so when the channel
        clears, the original frame, plus repeats, plus a string of
        <DISC> frames are sent!


        KISS With Checksum
        ~~~~~~~~~~~~~~~~~~

        Checksum-KISS appends a single byte checksum to the "data"
        portion of the frame, to detect line errors.  Frames that
        fail the checksum test are silently discarded.  The upper
        layer eventually detects the loss and re-sends the frame.


        KISS With Acknowledgement (ACKMODE)
        ~~~~~~~~~~~~~~~~~~~~~~~~~

        When operating in this mode, the host attaches a 16-bit
        "serial number" to each frame (between the "type" and "data"
        fields), and the TNC sends an "acknowledgement" frame to the
        host when it has transmitted that frame on-air.  This enables
        the host to know how much data is queued, and to start its
        AX25 timers at the correct time.  This mode uses the command
        code of 12 for both data frames and the acknowledgements.


        Polled KISS
        ~~~~~~~~~~~

        In this mode, the TNC does not send any data to the host until
        it is asked to do so by a POLL command (command number 14).

        This allows several TNC's to be multiplexed together (usually
        with a diode matrix) onto one COM port, which removes the need
        for one COM port per TNC.  Up to 16 TNC's can be multiplexed
        onto one COM port.  Each TNC must have a different "address",
        i.e. in the upper nybble of the Type field.
        

        Serial Line Parameters
        ~~~~~~~~~~~~~~~~~~~~~~

        Serial lines used for KISS must run at 8 data bits. Flow
        control must be hardware or none, as XON/XOFF flow control
        would interfere with the protocol.

        If flow control is used, the cable must contain at least 5
        cores, namely TXD, RXD, RTS, CTS and GND.  If flow control is
        not used, only TXD, RXD and GND are required.

        When KISS is used to connect a PC to a TNC, a "straight
        through" cable is used, because a TNC is considered a DTE
        (Data Terminal Equipment). 

        When KISS is used to interconnect two applications, some form
        of NULL MODEM is required. In the case of "real"
        RS232 this could be an actual null modem device, or a cable
        that is wired such that the TXDs at each end go to the RXDs
        at the other end, and the RTSs at each end go to the CTSs at
        the other.  "Virtual" COM port pairs such as Com0Com include
        this functionality as standard.


        Configuring a KISS Link
        ~~~~~~~~~~~~~~~~~~~~~~~

        KISS can be used to link XRouter with KISS TNC's, or with
        other KISS systems via real or "virtual" COM ports. A typical
        configuration in XROUTER.CFG would be as follows:

                INTERFACE=1
                        TYPE=ASYNC       <-- Serial RS232
                        COM=1            <-- COM port number (*)	
                        PROTOCOL=KISS    <-- Use KISS
                        SPEED=38400      <-- Baud rate
                        FLOW=0           <-- No flow control
                        MTU=256          <-- See below
                        KISSOPTIONS=NONE <-- Plain KISS
                ENDINTERFACE

                (*) On Linux versions COM specifies a TTY device name.

        MTU specifies the largest size for the data portion of an AX25
        frame, and the largest IP datagram that can be handled.  This
        should be set to 256 for KISS TNC's because they usually have
        small packet buffers.  For KISS links not using TNC's, MTU may
        be set larger, up to 1500.

        KISSOPTIONS are as follows:

            NONE     - Plain KISS (most TNC's use this) (default)

            POLLED   - For TNCs which send only when polled.

            CHECKSUM - Packets protected by checksum.  You can
                       only use this option if your TNC supports it.

            ACKMODE  - For TNC's which inform XRouter when a frame has
                       been transmitted on air.

            SLAVE    - XRouter will act like a polled KISS TNC,
                       sending only when commanded to do so.

            Polled and slave are mutually exclusive.
            BPQKISS eproms require POLLED and CHECKSUM, and their use
            of ackmode is optional.


        The PORT is configured like this:

                PORT=3
                        ID=144.675MHz User Port
                        INTERFACENUM=1
                        CHANNEL=B
                ENDPORT


        CHANNEL is only required if the TNC is not using its default
        channel / port.


        KISS TNC's
        ~~~~~~~~~~

        Most TNC's can be switched into KISS mode using a command
        such as "KISS ON", but they have a tendency to randomly drop
        back to command mode.  Therefore it is more usual to replace
        the EPROM with a purpose made KISS EPROM. There are several
        versions, such as BPQKISS, JKISS, KISS and 220KISS.  These
        usually default to channel A, but can be "patched" for other
        channels.

        For example the BPQKISS EPROM may be patched for different
        KISS channels by changing the byte at address 20(hex) in the
        PROM as follows:

                Channel Byte-20h     Channel Byte-20h
                ----------------     ----------------
                   A      00h           I      80h
                   B      10h           J      90h
                   C      20h           K      A0h
                   D      30h           L      B0h
                   E      40h           M      C0h
                   F      50h           N      D0h
                   G      60h           O      E0h
                   H      70h           P      F0h

        Once in KISS mode, the only way to switch a conventional TNC
        back to normal mode is to send the sequence 192, 255, 192 on
        the serial line.  This can be done using a terminal program
        and the numeric keypad, or a simple program such as
        KISSOFF.EXE.


        Dial-Up KISS
        ~~~~~~~~~~~~

        A temporary KISS connection may be established over an XRouter
        dial-up link using the MODE command in the DUN script.  This
        is only likely to be of use where phone calls are free!

SEE ALSO
        DUN(9)         -- Dial-up Networking.
        SLIP(9)        -- Serial Line Internet Protocol.
        XROUTER.CFG(8) -- Main Configuration File.

KISS(9)                     END OF DOCUMENT
