L2FRAG(9)               XROUTER REFERENCE MANUAL            17/10/2023

NAME
        L2FRAG -- AX25 Layer 2 Fragmentation.

DESCRIPTION
        Data originated by XRouter is always packaged into the correct
        sized frames for the underlying link.  For AX25, this size is
        specified by PACLEN, which defines the largest payload of an
        information-bearing frame.

        However XRouter has no control over the size of NetRom
        datagrams originated at other systems, which may be larger
        than the PACLEN of the AX25 L2 link onto which they are to be
        routed.

        To cope with this situation, XRouter includes a layer 2
        fragmentation scheme, which (if enabled) breaks the datagram
        into two or more PACLEN (or smaller) chunks.  This scheme is
        only used for connected-mode AX25 (LAPB).  It supersedes an
        earlier NetRom-specific fragmentation scheme which appears to
        be no longer used.

        A fragmented datagram is indicated by the presence of a
        2-byte PID (Protocol Identifier) field in place of the usual
        single-byte field.  The first byte has the decimal value 8,
        indicating that a second PID byte follows.  The second byte
        indicates how many segments (up to 127) remain to be sent.
        The first segment is indicated by the value 128, and the last
        segment by 0, i.e. no fragments left.

        Whether or not XRouter uses fragmentation is controlled by
        bit 4 of CFLAGS (decimal 16).  If this bit is set, XRouter
        fragments outgoing datagrams if necessary.  If the flag is
        not set, datagrams are sent unfragmented.  This flag should
        only be set if the peer is known to be capable (xNOS systems
        usually are).

        If a fragmented datagram is received from a peer, that peer
        is assumed to be capable of fragmentation, and XRouter will
        enable fragmentation (and re-assembly of received fragments)
        regardless of the setting of bit 4 of CFLAGS. 

        Compatible Systems
        ~~~~~~~~~~~~~~~~~~

        xNOS and all versions of XRouter are known to be compatible
        with this scheme. The status of others such as BPQ32, PE1CHL
        Net etc. are unknown at the time of writing (2013). Reports
        would be appreciated.

SEE ALSO
        CFLAGS(7) -- Connection Control Flags
        L3FRAG(9) -- NetRom Layer 3 Fragmentation.
        PACLEN(1) -- AX25 Max Packet Length.
        
L2FRAG(9)                   END OF DOCUMENT
