L3RTT(9)              XROUTER REFERENCE MANUAL               1/10/2025

NAME
        L3RTT -- Layer 3 Round Trip Time.

DESCRIPTION
        L3RTT is an acronym for "Layer 3 Round Trip Time". L3RTT is a
        protocol for measuring the round trip time (RTT) of links.

        Round trip time is used to estimate the performance of a link.
        The smoothed one-way trip time is used in making routing
        decisions, and during the automatic estimation of route
        QUALITY (Autoqual).

        Whilst the layer *2* RTT for a link can be estimated by timing
        how long it takes to get an acknowledgement to a given AX25L2
        frame, this doesn't tell the full story.  The RTT may be good,
        yet the link may be experiencing delays simply because there
        is too much traffic queued on the link.

        L3RTT uses a special type of NetRom layer 3 packet which is
        immediately reflected back by the neighbour if it understands
        the protocol.  This packet is queued with other link traffic,
        so it gives a more accurate estimate of the layer 3 RTT at
        that moment.  The interval between queueing the L3RTT packet
        and receiving the returned packet is the layer 3 RTT.

        XRouter sends L3RTT packets on already-open neighbour node
        links at 5 minute intervals.  L3RTT does not open closed
        links.


        L3RTT frame format:
        ~~~~~~~~~~~~~~~~~~

        Bytes: 7       7       1     1   1   1   1   1            1
           .-------.-------.-------.---.---.---.---.---.--------.----.
           | l3src | L3dst | l3ttl | 0 | 0 | 0 | 0 | 5 | <text> | CR |
           '-------'-------'-------'---'---'---'---'---'--------'----' 
           <----- L3 Header ------><- Dummy L4header -><- Payload -->

           <l3src> is the sender's NODECALL
           <l3dst> is L3RTT-0
           <L3ttl> is 2 (decremeted to 1 by recipient)

        The dummy header simulates L4 <INFO S0 R0>, and the <text>
        field is as follows (one space between each field):

          6    10    10    10    10      6     11    n      n
        <fid> <ts> <srtt> <rtt> <pid> <alias> <id> <vers> <flg>


            <fid>   Frame ID "L3RTT:"
            <ts>    Time stamp (10ms units)
            <srtt>  Smoothed Round Trip Time
            <rtt>   Last round trip time.
            <pid>   Unique ID for this packet.
            <alias> Nodealias of sender.
            <id>    INP3 version identifier: "LEVEL3_V2.1"
            <vers>  Software name and version e.g. "XRouter201c"
            <flg>   Flags field (see below) 

            Flags Field:

            Each flag consists of the "$" character followed by a
            character indicating the flag type. Some flags include
            additional data.  There is whitespace between flags, but
            not within them.  The following flags are defined:

            Flag  Description
            --------------------------------------------------
            $Hn   Max Hops, e.g. "$H5"
            $In   IP version n frames are accepted , e.g. $I4
            $Mn   Max trip time (10ms units) e.g. "$M60000"
            $N    Indicates that the sender is INP3-capable
            $Vn   INP version number (v4 and above), e.g. $V4

NOTES
        The above formatting can no longer be relied upon, as some
        faulty 64-bit softwares are overflowing the 10-byte fields!

        Some people complain that the L3RTT packets are too long. But
        that's the point! They are supposed to simulate typical data
        bearing frames. Short packets would give over-optimistic
        measurements, and may succeed on poor links where longer
        data-bearing packets would be subject to retries. 

SEE ALSO
        AUTOQUAL(9) -- Automatic Route Quality
        QUALITY(1)  -- Netrom Route Quality

L3RTT(9)              END OF DOCUMENT
