L4LINKS(1)              XROUTER REFERENCE MANUAL             18/8/2025

COMMAND
        L4LINKS -- Display current NetRom level 4 circuits.

SYNOPSIS
        L4[links] [circuit#]

DESCRIPTION
        The L4LINKS command is is used to list NetRom level 4 circuits
        and to display individual ciruits in detail.  It is mainly of
        interest to sysops. It shows the callsigns and circuit numbers
        being used at each end of the circuit plus some other 
        data, such as frame counts.

        The command may be abbreviated to "L4".

OPTIONS
        When used without arguments, e.g. "L4L", a list of circuits is
        displayed.

        If a hexadecimal argument is supplied, e.g. "L4L 1d5", the
        circuit with the matching local circuit number is displayed in
        more detail.

EXAMPLE
        G8PZT:KIDDER} L4 Links:

        Local   Cct Remote@Host Cct S  Txq Rxq Rtt Tr T/o Con Cho Ack 
        G8PZT-4 111 G8PZT G8PZT 210 2  0   0   0   0  120 121 0   0

        The fields are as follows:

           Local  - Layer 3 callsign at our end of the circuit.
           Remote - Layer 3 user callsign at far end of circuit.
           Host   - Remote node callsign.
           Cct    - Circuit numbers at each end.
           S      - Link state as follows:
                      1 = Outgoing connection initiated.
                      2 = Connected.
                      3 = Disconnection requested locally.
                      4 = Disconnected, awaiting local CLOSE.
                      5 = Shutdown, i.e. close after all data sent.
           Txq    - No. of L2 frames queued for transmission.
           Rxq    - No. of L2 frames on receive queue.
           Rtt    - Round Trip Time.
           Con    - Connection timer seconds remaining.
           Cho    - Choke timer seconds remaining.
           Ack    - ACK timer seconds remaining.

AVAILABILITY
        The L4LINKS command is available to all users.

SEE ALSO
        AXROUTES(1) -- Display current & recent L2 links
        LINKS(1) -- Display current AX25 Layer 2 connections

L4LINKS(1)                  END OF DOCUMENT
