;*************************** Max Width *******************************
LAN(6)                 XROUTER REFERENCE MANUAL              23/9/2023

NAME
    LAN -- LAN Interfacing. 

DESCRIPTION
        There are TWO ways for XRouter to interface with the LAN or
        WiFi. Which one you choose depends on the facilities you need.

        The "basic" method accesses the LAN via the Linux kernal.

        This mode supports servers, AXIP, AXUDP, AXTCP, IPIP, IPUDP,
        Telnet, PING, TraceRoute etc.

        It does NOT support direct IP routing between XRouter ports
        and the LAN.

        For example, it wouldn't be able to route "raw" IP from a PPP
        port or RF network onto the LAN (and vice versa).

        But it CAN route encapsulated traffic to and from the LAN.
        For example, you could receive IP over the radio, or over
        AXIP / AXUDP / IPIP / IPUDP / PPP / SLIP etc, and route it
        out via the LAN to another node, providing it is encapsulated
        in IPIP, IPENCAP, IPUDP, IP-over-AXUDP, IP-over-AXIP,
        IP-over-AXTCP etc.

        Using basic mode, it is not possible (yet) to "trace" the
        Linux kernal TCP/IP activity. Only encapsulated traffic and
        non-LAN traffic can be traced.

        Basic mode does not need an INTERFACE or PORT for the LAN.
        All it needs is a "type k" (kernal) default route in
        IPROUTE.SYS like this:

            ip route default  0  *  k

        In this mode, all servers and LAN traffic in and out of
        XRouter use Linux's LAN IP address.

        The "regular" method for accessing the LAN bypasses the Linux
        kernal, talking to the hardware in a more direct way.

        This mode gives XRouter its own LAN address and IP stack,
        independent of the Linux one.

        It supports all the above modes, PLUS it supports direct IP
        routing between XRouter ports and the LAN. All LAN traffic
        to and from XRouter can be "traced".

        Regular mode uses an EXTERNAL interface, to which a PORT is
        attached. They are declared as follows:

            INTERFACE=3
                TYPE=EXTERNAL        ; External device driver
                ID=eth0              ; Device to use
                PROTOCOL=ETHER       ; Protocol
                MTU=1064             ; Largest packet size
            ENDINTERFACE

        The "ID=" directive tells XRouter which Ethernet adaptor to
        use. This is normally "eth0". If you use an invalid device
        name, e.g. "eth1", XRouter will start, but will not be able
        to use Ethernet.

        Device "eth0" is usally the Ethernet adaptor and wlan0 is
        usually the WiFi adaptor. However, the WiFi may appear as
        "eth1".

        The only PROTOCOL accepted at present is ETHER.

        The corresponding Ethernet PORT is declared like this:

            PORT=1                     ; Port number
                ID=Ethernet            ; Description
                INTERFACENUM=3         ; Interface to use
                IPADDRESS=192.168.0.2  ; Ethernet IP address
                NETMASK=255.255.255.0  ; Network mask
                etc...

        INTERFACENUM must refer to the number of the INTERFACE
        previously defined.

        The port number is not important. It is merely a "handle" for
        users of the port. It doesn't have to match the INTERFACE
        number.

        IPADDRESS specifies XRouter's IP address, overriding the
        global IP address only on that port.

        Make sure you choose a different IP address to any that Linux
        is using!

        You will also need to set up some LAN IP routing in
        IPROUTE.SYS, for example:

            # Default route via gateway 192.168.0.100 on port 1:
            ip route default  1  192.168.0.100  d
            #
            # Local subnet is routed direct on port 1:
            ip route add 192.168.0.0/24          *  1  d

CAVEATS
        If XRouter is run as a root user, no special conditions apply.

        If not run as root, its access to resources is restricted by
        Linux's security policies.

        When running as a non-root user, "basic" mode requires
        XRouter to have CAP_NET_BIND_SERVICE capability if any of its
        server ports on the Linux stack are below 1024. See
        TCP-PORTS(6) for more information and workarounds.

        To run "normal mode" as a non-root user, the "XRouter"
        executable needs CAP_NET_RAW capability. See CAPFLAGS(6) for
        more information. 

SEE ALSO
        IP-STACKS(6)   -- IP Stacks in XRouter.
        TCP-PORTS(6)   -- TCP Server Ports.
        IPROUTE.SYS(8) -- IP Routing Tables.
        CAPFLAGS(6)    -- Capability Flags.
        XROUTER.CFG(8) -- Main Configuration File.

LAN(6)                    END OF DOCUMENT
