LANGS.SYS(8)           XROUTER REFERENCE MANUAL               10/9/2023

NAME
        LANGS.SYS -- Language Control File.

DESCRIPTION
        This optional file is read only at bootup. It controls which
        language is used for a caller's session, based on their
        callsign.

        By default, XRouter uses ENGLISH. If you want to support
        additional languages, install the relevant language file(s)
        as follows:

            French   - FRANCAIS.SYS
            Spanish  - ESPANOL.SYS
            German   - DEUTSCH.SYS
            Dutch    - NEDERLANDS.SYS

        Language files are read only at bootup.

        All sessions use ENGLISH by default, UNLESS you install
        LANGS.SYS, which tells XRouter which language to use for a
        given callsign.

FORMAT
        The entries in LANGS.SYS are of the form:

            <callsign_mask> <language_number>

        The <callsign_mask> field specifies which callsign(s) will
        use the <language_number>. It can be a single callsign e.g.
        "F1OTJ" or a wildcard match, e.g. "F*".

        <language_number> is a pre-defined index number for the
        language to be used. These numbers are fixed, no matter how
        many language files are installed: English is always number
        0, French is always number 1 and so on.

        Comment lines beginning with "#" or ";" in the leftmost
        column are allowed.

        If you refer to a language nuber, you MUST install that
        language file.

EXAMPLE
        # LANGS.SYS
        #
        # Language selection file for XRouter v502
        #
        # Line format: <callsign_mask> <language_number>
        #
        # Language numbers:
        #
        # 0     English
        # 1     Francais
        # 2     Espanol
        # 3     Deutsche
        # 4     Nederlandse
        #
        # The default language for any callsign prefix not in the
        # list below is set by DEFAULTLANG in XROUTER.CFG.
        #
        2*      0
        3A*     1
        EA*     2
        F*      1
        G*      0
        H*      1
        M*      0
        ON1K*   1
        ON4*    1
        ON5*    1
        ON6*    1
        ON7*    1
        ON8*    1
        ON9*    1
        PA*     4
        PB*     4
        PC*     4
        PD*     4
        PE*     4
        PF*     4
        PH*     4
        PH*     4
        PI*     4
        TK*     1
        TU*     1
        VA2*    1
        VE2*    1

CAVEAT
        When BBS software is making connections for forwarding, it
        expects to see the English  words "CONNECTED TO". If this is a
        problem, e.g. the BBS is French you have two options. The first
        option is to "comment out" text no. 94 in FRANCAIS.SYS,
        allowing it to revert to English for that text only. The second
        option is to add an exception for that BBS into this file,
        assigning its language to English, e.g. "F1BBS 0". The
        exception should be added BEFORE any wildcard entries for that
        group pf caallgigns.

NOTES
        XRouter's inbuilt language is ENGLISH. If you wish, you may
        change the layout and/or wording of most XRouter responses by
        installing ENGLISH.SYS in the same directory as XRouter.
        XRouter will then use the texts from that file, which you may
        modify, instead of the inbuilt ones.

        Be careful with modifications, because some of the texts are
        used in multiple places, and some of them are column headers
        which need to follow a strict format. Installing and modifying
        this file is NOT recommended, but it's up to you!

        Similar comments apply to the other language files. If you can
        improve on them, please do so, and share the results.

        If your language is not (yet) one of the supported ones, and
        you don't need English, translate ENGLISH.SYS into your own
        language. That will become the default language.

SEE ALSO
        LANG(1)        -- Display / Set Session Language
        CONSOLELANG(7) -- Console language
        DEFAULTLANG(7) -- Specify default language
        XROUTER.CFG(8) -- Main configuration file

LANGS.SYS(8)              END OF DOCUMENT
