;*************************** Max Width *******************************
LATITUDE(7)            XROUTER REFERENCE MANUAL               6/9/2023

NAME
        LATITUDE -- Set XRouter's geographic latitude

SYNOPSIS
        LATITUDE=n  (where n is between -90.0 and 90.0)

DESCRIPTION
        LATITUDE is an optional directive, used in XROUTER.CFG. If
        present, it specifies XRouter's geographic latitude.

        LATITUDE is not needed if (a) LOCATOR is specified, or (b) a
        valid APRS position string is present at the start of IDTEXT.
        In either case, LATITUDE is deduced from the supplied values.

        However if LATITUDE and LONGITUDE are supplied and LOCATOR
        isn't, the latter is calculated.
        
        XRouter uses position information to calculate distances and
        directions to other nodes, as displayed in the MHeard and DX
        lists, and to calculate sunrise and sunset times etc. Whilst
        not vital, these things make node-hopping more interesting.
        Therefore XRouter will not run unless some form of position
        is supplied.

        Unless disabled by the sysop, position information is also
        reported to a mapping server, in an attempt to draw a near
        real-time network map.

        Positional precision is left to the sysop. There is rarely a
        need to know EXACTLY where a node is, its approximate
        location being sufficient for most purposes. Latitude is
        currently stored with a MAXIMUM precision of a hundredth of a
        minute, ie around 22 metres, so there is no point trying to
        supply a LATITUDE of greater precision.

        Within reason, a false location may be supplied, but if the
        position is an obvious mismatch for the nodecall, XRouter
        won't run.

OPTIONS
        The argument to LATITUDE is a decimal number of degrees
        between -90.0 (South Pole) and 90.0 (North Pole). Note that
        this is DECIMAL DEGREES, not degrees, minutes and seconds.

        Southern latitudes are specified using NEGATIVE numbers. You
        should not append N or S after the number.

EXAMPLE
        LATITUDE=52.4     -- An imprecise northern latitude
        LATITUDE=-77.6342 -- A more precise southern latitude 

SEE ALSO
        IDTEXT(1)      -- Display / Set ID beacon text
        LOCATOR(7)     -- Maidenhead QTH locator
        LONGITUDE(7)   -- Geographic longitude
        XROUTER.CFG(8) -- Main Configuration File

LATITUDE(7)                  END OF DOCUMENT
