;***********************|****|* Max Width *|***|*********************|
LEARN(7)                XROUTER REFERENCE MANUAL             26/9/2023

NAME
        LEARN -- Learn Unsolicited AX*P Peer Details.

SYNOPSIS
        LEARN=1

DESCRIPTION
        LEARN is an optional directive that is used only in one type
        of PORT block within XROUTER.CFG.  It enables "learning" of
        AXIP / AXUDP routing information for unsolicited peers, i.e.
        those for whom no PEER statement exists.

        This allows return packets to be routed to the caller for a
        limited time. If the connection is not used for 10 minutes,
        the details are purged. As the normal AX25 T3 "link check"
        interval is 5 minutes, purging only happens after the link
        has been dead for a while.

        LEARN is only valid if the PORT has "IPLINK=0.0.0.0" and is
        attached to an INTERFACE which has "TYPE="AXUDP". Only one
        such PORT can exist, but it can co-exist with "normal" AXIP
        and AXUDP ports, i.e. those which have IPLINK that is not
        "0.0.0.0".

OPTIONS
        The argument for LEARN can be either zero or non-zero. The
        former is the default condition if the directive is not
        present. Any non-zero argument enables learning.

SEE ALSO
        AD-HOC(9)      -- Ad-Hoc Networking.
        AXIP(9)        -- AX25 over IP
        AXUDP(9)       -- AX25 over UDP
        PEER(7)        -- Specify AXIP / AXUDP Link Partner
        XROUTER.CFG(8) -- Main Configuration File

LEARN(7)                     END OF DOCUMENT
