LINKS(1)                XROUTER REFERENCE MANUAL             18/8/2025

COMMAND
        LINKS -- Displays the current AX25 layer 2 sessions.

SYNOPSIS
        L[inks] [id#]

DESCRIPTION
        The LINKS command lists AX25 layer 2 user up/downlinks and
        internode links.  It is mainly of interest to sysops. It shows
        the callsigns being used at both ends of the link plus some
        other data, such as frame counts and retry rates.

        The command may be abbreviated to "L".

OPTIONS
        When used without arguments, e.g. "L", a list of links is
        displayed.

        If a decimal argument is supplied, e.g. "L 25", the link with
        the matching ID number is displayed in more detail.  The ID
        number is obtained from the last column of the summary (see
        below).

EXAMPLE
        This is the response to the plain "L" command:

        G8PZT:KIDDER} AX25 L2 Links:
        Remote Local  Prt Sta Ver Try  T3   Pac  Max Idle  Txq Rxq  Id
        G4FPV  G8PZT   5   5   2   0   177  160   1    90    0   0   1
        GB7PZT G8PZT   7   5   2   0   181  240   7   201    0   0   2
        GB7GH  G8PZT   9   5   2   0   176  120   1    32    3   1  17
        (End of list)

        The fields are as follows:

           Remote - L2 callsign at far end of link
           Local  - L2 callsign at our end of the link.
           Prt    - Port number
           Sta    - Link state (2 = connecting, 4 = disconnecting,
                                5 = connected)
           Ver    - AX25 version number
           Try    - Retry count
           T3     - Current state of the LAPB T3 countdown in secs
           Pac    - Paclen
           Max    - Maxframe
           Idle   - Secs since there was any activity on the link
           Txq    - No. of L2 frames queued for transmission
           Rxq    - No. of L2 frames on receive queue
           Id     - Connection ID number.
#          Asm    - No. of frame fragments awaiting reassembly

AVAILABILITY
        The LINKS command is available to all users.

SEE ALSO
        AXROUTES(1) -- Display current & recent L2 link info.
        L4LINKS(1) -- Display current NetRom level 4 circuits.

LINKS(1)                    END OF DOCUMENT
