;***********************|****|* Max Width *|***|*********************|
LISTEN(1)               XROUTER REFERENCE MANUAL              5/8/2024

NAME
        LISTEN -- Listen For Incoming Connections.

SYNOPSIS
        LIS[ten] <portnum> [0]

DESCRIPTION
        The LISTEN command, which can be abbreviated to "LIS",
        initiates "listen mode" on a specified PORT.

        In this mode the user is (optionally) able to "monitor" packet
        traffic on the chosen port, and the node will accept incoming
        connections to the user's callsign.

        For scurity reasons, non-sysops may only listen on RADIO
        ports. It is not possible to listen on the session's "uplink"
        port.

        Traffic monitoring is enabled by default, but may be disabled
        by supplying 0 (zero) as an optional additional argument. 

        All the normal node commands are available in listen mode.
        Additionally the CQ command can be used to advertise the
        user's presence.

        The user's SSID is inverted in the usual Net/Rom way, so if
        the uplink is G9XYZ, they will be listening and beaconing as
        G9XYZ-15.

        Upon incoming connection to a "listener", traffic monitoring
        is disabled, the user is notified of the incoming connection,
        and the connection becomes a normal "transparent" throughlink.

        If either party disconencts, they are both disconnected.

OPTIONS
        To exit listen mode use "LISTEN 0" or "LISTEN OFF"

EXAMPLES
        LISTEN 3    - Listen on port 3 with traffic monitoring.
        LISTEN 5 0  - Listen on port 5 without traffic monitoring.
        LIS OFF     - Exit listen mode.

AVAILABILITY
        All users.

SEE ALSO
        CQ(1)    -- Send a CQ Message.
        WATCH(1) -- Monitor traffic on port(s).

LISTEN(1)                    END OF DOCUMENT
