LOADNODES(1)            XROUTER REFERENCE MANUAL            17/10/2023

COMMAND
        LOADNODES -- Load the nodes and routes tables from disk.

SYNOPSIS
        LOADNODES [filename]

DESCRIPTION
        The LOADNODES command loads the nodes and routes tables from 
        a "recovery" file.  This file is written when XRouter closes
        down, unless the "-N" switch is used, and read by XRouter at
        start up, unless the "-n" (noNodes) switch is used.

        The recovery file is used to reconstruct the Netrom routing
        tables without having to wait for nodes broadcasts to be
        received.  The LOADNODES command allows you to load the
        tables at any time without taking XRouter off line.

        The optional argument specifies the filename to load from, and 
        if not specified it defaults to XRNODES.

        It is recommended that, once in a while, you use the SAVENODES 
        command to save a "good" copy of the nodes tables to a file 
        other than XRNODES.  This will ensure that, should the tables 
        become depleted, for example due to a radio failure, they can 
        be reloaded when the problem is fixed, without rebooting.

EXAMPLES
        LOADNODES              - Load from default file XRNODES
        LOADNODES nodebak.txt  - Load from file "NODEBAK.TXT"

FILES
        The XRNODES file is similar in format to the BPQNODES file
        used with the DOS version of BPQ node, but is no longer
        compatible with it. 

        XRNODES is a plain text file, which may be viewed with
        Notepad by adding the extension .TXT.

CAVEATS
        The LOADNODES command should be used with caution, because it
        can result in obsolete nodes being re-introduced into the node
        table.

AVAILABILITY
        Sysop-only.

SEE ALSO
        SAVENODES(1) -- Save Nodes and Routes to Disk.
        XRNODES(8) -- Nodes / Routes Recovery File.

LOADNODES(1)                END OF DOCUMENT
