;*************************** Max Width *******************************
LOCATOR(7)             XROUTER REFERENCE MANUAL               6/9/2023

NAME
        LOCATOR -- Maidenhead QTH locator

SYNOPSIS
        LOCATOR=LLddLL[dd] (where L is a letter and d is a digit)

DESCRIPTION
        LOCATOR is an optional directive, used in XROUTER.CFG. If
        present, it specifies XRouter's Maidenhead QTH locator.

        LOCATOR is not needed if (a) LATITUDE and LONGITUDE are
        specified, or (b) a valid APRS position string is present
        at the start of IDTEXT. In either case, LOCATOR is deduced
        from the supplied values.

        However if LOCATOR is supplied, but LATITUDE and LONGITUDE
        are not, the latter are calculated.
        
        XRouter uses position information to calculate distances and
        directions to other nodes, as displayed in the MHeard and DX
        lists, and to calculate sunrise and sunset times etc. Whilst
        not vital, these things make node-hopping more interesting.
        Therefore XRouter will not run unless some form of position
        is supplied.

        Unless disabled by the sysop, position information is also
        reported to a mapping server, in an attempt to draw a near
        real-time network map.

        Positional precision is left to the sysop. There is rarely a
        need to know EXACTLY where a node is, its approximate
        location being sufficient for most purposes.

        A 6-character LOCATOR puts the node in the middle of a 1KM
        square. An 8 character locator defines a square of 15 secs
        of latitude by 30 secs of longitude.

        Within reason, a false location may be supplied, but if the
        position is an obvious mismatch for the nodecall, XRouter
        won't run.

OPTIONS
        The argument to LOCATOR is a 6 or 8 character "Maidenhead"
        locator, e.g. "IO82VJ" or "IO75GH65"

EXAMPLE
        LOCATOR=IO82VJ    -- Kidderminster UK

SEE ALSO
        IDTEXT(1)      -- Display / Set ID beacon text
        LATITUDE(7)    -- Geographic latitude
        LONGITUDE(7)   -- Geographic longitude
        XROUTER.CFG(8) -- Main Configuration File

LOCATOR(7)                  END OF DOCUMENT