LOG(7)                XROUTER REFERENCE MANUAL                6/9/2023

NAME
        LOG -- Activity logging options

SYNOPSIS
        LOG=n (where n is between 0 and 16383)

DESCRIPTION
        The optional LOG directive, used in XROUTER.CFG, controls
        the logging of XRouter activity, such as connections,
        disconnections, errors, user commands etc. If the directive
        is omitted, or is set to 0, no logging is done.

OPTIONS
        The argument to LOG is a decimal value between 0 and 16383
        formed by summing the values of the desired options from the
        table below:

          Value    Function
          ---------------------------------------------------
              1    Enable logging to disk
              2    Use CRLF instead of LF line endings
              4    Log session activity
              8    Log TCP/UDP events
             16    Log Netrom layer 4 events
             32    Log IP/ICMP layer events
             64    Log Netrom layer 3/inp3
            128    Log ODN activity.
            256    Log IDS activity to IDS log
            512    Generate PCAP file (use with caution)
           1024    Log daemon process events
           2048    Log AX25 over TCP
           4096    Log AX25 connections etc
           8192    Log interface layer events

EXAMPLES
        LOG=7  -- Log session activity, using CRLF line endings
        LOG=65 -- Log Netrom L3 only, using LF line endings
    
SEE ALSO
        LOG(1)         -- Activity logging control command
        XROUTER.CFG(8) -- Main configuration file

LOG(7)                   END OF DOCUMENT

