LOG(1)                XROUTER REFERENCE MANUAL                9/9/2023

COMMAND
        LOG -- Control activity logging.

SYNOPSIS
        LOG [ON | OFF]
        LOG <flags>
        LOG <system> [level]

AVAILABILITY
        Console, BOOTCMDS.SYS, and remote sysops only.

DESCRIPTION
        The LOG command is used to enable or disable the logging 
        of XRouter activity, such as connections, disconnections, 
        errors, user commands etc.  It overrides the default setting
        that was specified using "LOG=n" in XROUTER.CFG, and allows
        finer control.

OPTIONS
        If LOG is used without arguments, the current setting of the
        "log flags" is shown. These are simple on-off switches for
        the various layers / sub-systems. The number returned is the
        sum of the active flags in the "value" column of the table
        below:

                 Value   Function
                 ----------------------------------------------
                    1    Enable/disable logging
                    2    Use CRLF instead of LF line endings
                    4    Log session activity
                    8    Log TCP/UDP events
                   16    Log Netrom layer 4 events
                   32    Log IP/ICMP layer events
                   64    Log Netrom layer 3/inp3
                  128    Log ODN activity.
                  256    Log IDS activity to IDS log
                  512    Generate PCAP file (use with caution)
                 1024    Log daemon process events
                 2048    Log AX25 over TCP
                 4096    Log AX25 connections etc
                 8192    Log interface layer events

        If the argument to LOG is a numeric value between 0 and 16383
        the log flags are set to that value.

        For example, to log session layer and Netrom L4 activity in
        Windows/DOS format, you would use "LOG 23" (1+2+4+16). To log
        EVERYTHING, it would be "LOG 16383", and to log everything
        except PCAP (packet capture), LOG would be 15871 (16383-512).

        If a "log flag" is "on", the verbosity level (see below) for 
        that subsystem or group of subsystems is set to 6, i.e. 
        "routine information". When the flag is "OFF", the verbosity
        level is 0 (no logging).

        If the argument to LOG is the mnemonic of a sub-system, the
        verbosity "level" for that sub-system can be displayed or
        changed. Sub-system mnemonics currently supported are:

          Mnemonic  Subsystem
          --------------------------------------------
            AGWC    AGW Client
            AXTCP   AXTCP Interface
            CHAT    Chat server
            CONS    Console
            FTPC    FTP and NFTP clients
            FTPS    FTP and NFTP servers
            HTTP    HTTP server
            IFTCP   TCP interface
            INP3    Inp3 network admin
            LAPB    AX25 connected mode
            MAPD    Map update daemon
            MQTT    MQTT client, broker and daemon
            NRL3    Netrom layer 3
            NRL4    Netrom layer 4
            ODN     On-demand networking
            PROC    Daemon processes
            PMS     Personal Message System
            PMSD    PMS forwarding daemon
            SESS    Session layer
            SMSD    Short Message System forwarding daemon
            TCPH    TCP operations on host (kernal) stack
            TELN    Telnet

        As the conversion of the logging subsystem is only partially
        complete, more mnemonics will be added in due course. Use the
        LOG command without arguments to list the available mnemonics.

        <level> is the event's "priority" level between 0 and 7. The
        LOWER the number, the higher the importance of the
        information, as shown in the table below. Low numbers
        represent errors and events that must not be ignored, whilst
        the highest level is for verbose debug information that you
        wouldn't usually want to log.

          Level  Meaning
          ------------------------------------------------
            0    Total system failure
            1    Immediate action required
            2    Critical errors, e.g. hardware problems
            3    Survivable software errors
            4    Warnings
            5    Notifications that may need attention
            6    Normal operational messages
            7    Debugging

        Events are only logged if their priority level is equal to
        or LOWER than the "verbosity" threshold set by the sysop.
        For example, if a subsystem's verbosity level is 6, normal
        operational information, warnings and errrors are logged,
        but debug information isn't. If the verbosity level is 4,
        only the warnings and errors are logged. If the verhosity
        level is 0, nothing is logged.

        In the absence of the "LOG=n" directive in XROUTER.CFG,
        logging defaults OFF.

EXAMPLES
        LOG 19      -- Log NetRom layer 4 in CRLF format
        LOG OFF     -- Turn logging off (retains flags)
        LOG ON      -- Turn logging back on with previous settings
        LOG SESS 4  -- Log warnings and errors from session layer

FILES
        Log files are created in the LOG sub-directory of the XRouter
        working directory. One file is created per day, running from
        midnight to midnight local time. The files are plain text,
        and the file names take the form YYMMDD.LOG. e.g. 130119.LOG.

        The format of the entries in the log files is as follows:

            <time> <level> <system>: <comments>

        <time> is the timestamp in the form HHMMSS.

        <level> is the event's "priority" level between 0 and 7, as
                detailed in the table above.

        <system> is a sub-system mnemonic as listed above.

        <comments> is free-form, usually terse, and may contain
                    various machine-readable action codes.

        Example:

            004101 7 CHAT: Peer G8PZT-8 sess 6 timeout
            004101 6 NRL4: Requesting disconnect from G8PZT-8,
                            theirCct=2930 ourCct=6
            004101 6 SESS: 6 G8PZT-8@G8PZT-8 SK R:97 S:33
            004121 6 NRL3: L3RTT request to G8PZT
            004121 6 NRL3: L3RTT request to G8PZT-14
            004121 6 NRL3: L3RTT reply from G8PZT, TT=60ms
            004206 7 PROC: PB MAPD

        The meaning of the action codes are as follows (incomplete
        list):

           CU  - Uplink connection (followed by session type)
           DU  - Uplink disconnection
           CD  - Downlink connection
           DD  - Downlink disconnection
           HE  - HTTP Error
           HR  - HTTP Request
           PB  - Process Begins
           PE  - Proceess Ends
           SK  - Session kill (i.e. session ends)
           U   - User entered command

        The reason for the cryptic logging is to (a) save space and
        (b) allow the logs to be analysed by programs, for example to
        generate usage statistics.

CAVEATS
        Logging is useful if you are trying to rack down a problem,
        but it generates large volumes of data. This is unlikely to
        be an issue on a modern PC, but may become so if you were
        running XRouter on a 256Mb USB memory stick for example.

        The effect of logging on the longevity of SD cards is not
        known, but the author has had full debug logging enabled for
        at least 5 years with no problems.

SEE ALSO
        LOG(7)          -- Directive to set log flags
        BOOTCMDS.SYS(8) -- Commands to run at bootup
        XROUTER.CFG(8)  -- Main configuration fie.

LOG(1)                        END OF DOCUMENT
