;*************************** Max Width *******************************
LONGITUDE(7)           XROUTER REFERENCE MANUAL               6/9/2023

NAME
        LONGITUDE -- Set XRouter's geographic longitude

SYNOPSIS
        LONGITUDE=n  (where n is between -180.0 and 180.0)

DESCRIPTION
        LONGITUDE is an optional directive, used in XROUTER.CFG. If
        present, it specifies XRouter's geographic longitude.

        LONGITUDE is not needed if (a) LOCATOR is specified, or (b) a
        valid APRS position string is present at the start of IDTEXT.
        In either case, LONGITUDE is deduced from the supplied values.

        However if LATITUDE and LONGITUDE are supplied, and LOCATOR
        isn't, the latter is calculated.
        
        XRouter uses position information to calculate distances and
        directions to other nodes, as displayed in the MHeard and DX
        lists, and to calculate sunrise and sunset times etc. Whilst
        not vital, these things make node-hopping more interesting.
        Therefore XRouter will not run unless some form of position
        is supplied.

        Unless disabled by the sysop, position information is also
        reported to a mapping server, in an attempt to draw a near
        real-time network map.

        Positional precision is left to the sysop. There is rarely a
        need to know EXACTLY where a node is, its approximate
        location being sufficient for most purposes. Longitude is
        currently stored with a MAXIMUM precision of a hundredth of a
        minute, ie around 22 metres, so there is no point trying to
        supply a LONGITUDE of greater precision.

        Within reason, a false location may be supplied, but if the
        position is an obvious mismatch for the nodecall, XRouter
        won't run.

OPTIONS
        The argument to LONGITUDE is a decimal number of degrees
        between -180.0 (far West) and 180.0 (far East). Note that
        this is DECIMAL DEGREES, not degrees, minutes and seconds.

        Western longitudes are specified using NEGATIVE numbers. You
        should not append E or W after the number.

EXAMPLE
        LONGITUDE=2.5    -- An imprecise eastern longitude
        LONGITUDE=-5.205 -- A more precise western longitude 

SEE ALSO
        IDTEXT(1)      -- Display / Set ID beacon text
        LATITUDE(7)    -- Geographic latitude
        LOCATOR(7)     -- Maidenhead QTH locator
        XROUTER.CFG(8) -- Main Configuration File

LONGITUDE(7)                  END OF DOCUMENT
