;***********************|****** Max Width *****|*********************|
LOOP-IFACE(6)           XROUTER REFERENCE MANUAL             26/9/2023

NAME
        LOOP-IFACE -- Interface type "LOOPBACK".

DESCRIPTION
        The LOOPBACK interface is often misunderstood and mis-used.

        It is a relic of the DOS era, and has no practical use other
        than for test and development. YOU SHOULD NOT USE IT.

        It is an internal loopback within XRouter's stack only. It
        does NOT connect to Linux, and should be disabled if not
        needed because at the very least it may cause confusion, and
        may cause unwanted side effects.

        The "dummy" XROUTER.CFG file uses this interface for
        initial "off-line" testing, because it is the easiest way
        to create an INTERFACE and PORT, which XRouter needs
        before it will start. It gets a new sysop up and running
        quickly, and can always be used as a "known good"
        configuration, either from which to build a system, or to
        return to when troubleshooting.

        Once you have added some "real" interfaces and ports, you
        should remove or comment out the loopback one.

        The interface requires TYPE=LOOPBACK, PROTOCOL and MTU
        directives. Accepted PROTOCOLs are as follows:

            AX25     - Plain AX25, no CRC
            ETHER    - Ethernet
            HDLC     - AX25 with CRC, but no HDLC flags
            IP       - Plain IP
            KISS     - Basically AX25 within SLIP
            NETROM   - Netrom backend serial link.
            PPP      - Point to Point Protocol
            SLIP     - Serial Line Internet Protocol

            (see PROTOCOL(7) for more detail)

EXAMPLE
        #  Example "loopback" interface, allowing self-connects for
        #  test purposes only. This type of interface supports one
        #  PORT only.
        #
        INTERFACE=3
            TYPE=LOOPBACK
            PROTOCOL=KISS
            MTU=576
        ENDINTERFACE
        #
        #  Example loopback port, attached to loopback interface
        #  Use with caution. May cause catastrophic endless loops
        #  if IP routing is configured incorrectly.
        #
        PORT=3
            ID=Internal Loopback
            INTERFACENUM=3
        ENDPORT
        #

SEE ALSO
        IFACES(6)      -- Interfaces.
        KISS(9)        -- KISS Protocol.
        PORTS(6)       -- Ports in XRouter.
        PPP(9)         -- Point to Point Protocol.
        PROTOCOL(7)    -- Protocol Used on INTERFACE.
        XROUTER.CFG(8) -- Main Configuration File.

LOOP-IFACE(6)                END OF DOCUMENT
