;***********************|****|* Max Width *|***|*********************|
MAN(4)                  XROUTER REFERENCE MANUAL             29/3/2024

COMMAND
        MAN -- Display Sysop's Manual Pages.

SYNOPSIS
        MAN [section] [topic]

DESCRIPTION
        The MAN command is used to access the sysop's manual, which
        consists of a collection of pages, each covering a different 
        command or topic.

        The MAN pages are designed for sysop use, and usually give 
        more detail than the corresponding HELP pages.

        The manual is divided into several sections as follows:

           Section   Contents
           ------------------------------------------
              1      General Commands
              2      Chat Server Commands
              3      PZTDOS commands
              4      Mailbox commands
              6      Installation & Configuration Topics
              7      Configuration Directives
              8      Configuration / System Files.
              9      Miscellaneous Topics

        When used from the mailbox command line, MAN by default shows
        only the pages in section 4. Pages from other sections may be
        displayed using the [section] argument.

OPTIONS
        Use MAN SECTIONS to list the sections.

        Entering MAN alone displays a list of available topics in
        section 4.

        To read a specific page in section 4, enter MAN followed by
        the topic for which you require help.

        To list topics in any other section, enter MAN followed by the
        section number.

        To read a topic in a section other than 4, enter MAN followed
        by a space, the section number, a space then the topic.

        If a topic name contains wildcards, all matching topic names
        in the section are displayed.

EXAMPLES
        MAN LC       Display section 4 page for LC command.
        MAN 7        List the topics in section 7
        MAN 7 MAXTT  Display section 7 page for MAXTT directive
        MAN 1 I*     List section 1 topics begining with 'I'

CONVENTIONS
        The following conventions are used in MAN pages:

        < >         Mandatory argument - These braces and the text 
                    enclosed within them represent any piece of text 
                    typed after the command.  The <> do not form part 
                    of the argument.

        [ ]         Optional argument - These braces enclose anything 
                    which is not always present. If used within a 
                    command name (e.g. N[ODES]), this indicates that 
                    the command may be abbreviated to a minimum form 
                    while remaining unique.

AVAILABILITY
        Sysop-only.

FILES
        Manual files are normal text files, with the extension
        changed to ".MAN". They may be created and edited using a
        simple text editor such as Notepad (windows) or Leafpad, nano
        etc (Linux).

        All MAN files are located within the MAN directory, which
        itself is in the directory containing XRouter.

        As MAN files are for use only by the sysop, there is no need
        for separate directories for alternate language versions.
        Even if the MAN files are translated to a different language,
        they must always be situated in the MAN directory, not in a
        subdirectory thereof

        Filenames, including the extensions, MUST be in UPPER CASE.
        Lower case filenames and files without the .MAN extension are
        ignored.

        Within the .MAN files, lines beginning with a semicolon ';'
        are not displayed, so you can use them for comments, such as
        file modification details.

        Manual files can be viewed from the console using <ALT+H>
        followed by <M>. This browser window is only around 76
        characters wide, so try to keep the lines shorter than this,
        to preserve formatting. In any case, lines longer than 72
        characters are bad practice, typopgraphically-speaking.

LIMITATIONS
        Although most commands may be abbreviated, it is not currently 
        possible for the MAN command to correctly identify the 
        required page from an abbreviated argument.  Thus "MAN IMPORT" 
        is acceptable, whereas "MAN IM" is not. Use wildcards if
        necessary.

NOTE
        Some manual pages are longer than the standard console review
        buffer size, and may therefore display only the last 400 or
        so lines. However they can be viewed in full via the HTTP
        interface, and by using <ALT+H> followed by <M> at the
        console.

SEE ALSO
        HELP(4) -- General help system.

MAN(4)                      END OF DOCUMENT
