;*************************** Max Width *******************************
MAXFRAME(7)            XROUTER REFERENCE MANUAL              25/9/2023

NAME
        MAXFRAME -- Maximum Unacked AX25 Frames.

SYNOPSIS
        MAXFRAME=n (where n is in the range 1 to 63)

DESCRIPTION
        MAXFRAME is an optional PORT configuration directive used in
        XROUTER.CFG.

        It specifies the AX25 "window", i.e. the maximum number of
        unacknowledged frames allowed before the link must stop and
        wait for an ack. The normal range is between 1 and 7,
        although maxframes of up to 63 are allowed on modulo-128
        (EAX25) links. The default value of MAXFRAME is 3.

        The value can be changed during run-time using the MAXFRAME
        command.

OPTIONS
        If you set a value between 8 and 63, XRouter will attempt to
        use Modulo-128 (Extended AX25) on outgoing links. If the link
        partner is not capable of Modulo-128, the link will fall-back
        to normal AX25.

        If the port PACLEN is set to 0, XRouter dynamically adapts
        MAXFRAME (and PACLEN) to the link conditions, to maximise
        throughput.

EXAMPLE
        MAXFRAME=4 

SEE ALSO
        MAXFRAME(1)    -- Display / Set port MAXFRAME value.
        PACLEN(7)      -- Maximum AX25 Packet Length.
        PORTS(6)       -- Ports in XRouter.
        XROUTER.CFG(8) -- Main Configuration File.

MAXFRAME(7)                  END OF DOCUMENT
