MAXHOPS(7)              XROUTER REFERENCE MANUAL             25/9/2023

NAME
        MAXHOPS -- Set Hopcount Horizon.

SYNOPSIS
        MAXHOPS=n (n = 0-30)

AVAILABILITY
        Used only in XROUTER.CFG.

DESCRIPTION
        MAXHOPS is a global and PORT configuration keyword used in
        XROUTER.CFG, and a parameter which can be used in a ROUTE ADD
        command.

        It specifies the maximum accepted hop count for new nodes
        table entries received via INP3 unicasts from neighbours.
        Node information with hop counts that exceed this figure are
        not accepted into the nodes table.  This parameter has no
        effect on data received via conventional NetRom broadcasts.

        MAXHOPS would typically be used to limit the "hop horizon" to
        a smaller value than the default horizon, which is 30.  Like
        MAXTT, it can be used to limit the number of node entries
        that are accepted via a particular port or neighbour.

        For example, the RF purists don't like Internet-routed nodes
        cluttering up their tables, nor do they want traffic to
        "short-circuit" the RF links via tortuous multi-hop Internet
        routes.  In this case, a low MAXHOPS might be used at the
        interface between the RF-based network segment and the
        Internet-based segment, to (a) control the number of Internet
        nodes appearing in the nodes tables of the RF routers, and
        (b) limit the run-length of Internet routes.

        MAXHOPS can be used in 3 places:  If used in the "global"
        section of XROUTER.CFG, it specifies a default value for all
        ports, overriding the default of 30.  If used in a PORT
        configuration block, it overrides the global default.  All
        new routes inherit this value.  Finally the PORT value can be
        overridden for individual routes using by "locking-in" the
        route at the end of XROUTER.CFG, or by a ROUTE ADD command in
        the XRNODES file or at the command prompt. For example:  

                route add g8pzt 5 100 ! 0 0 0 2000 5

        This adds a locked in route to neighbour "g8pzt" on port 5,
        quality 100, with default maxframe, paclen and frack, MAXTT
        of 2000 and MAXHOPS of 5.

        Setting MAXHOPS to 0 will block all received INP3 data.

CAVEATS
        Using MAXHOPS to limit the no. of nodes learned via a
        neighbour may fail if the neighbour duplicates the INP3 data
        in NetRom nodes broadcasts.  This may enter nodes which are
        beyond your chosen hop limit into the nodes table and keep
        them refreshed.  The only defence is to ignore data from
        NetRom broadcasts by setting the port QUALITY below MINQUAL,
        or to set the MINQUAL high. Both actions may cause the loss
        of some NetRom-only nodes from the table.

SEE ALSO
        INP3(9)        -- InterNode Protocol
        MAXTT(7)       -- Maximum Trip Time.
        MINQUAL(1)     -- Display / Set port Minimum Quality
        QUALITY(1)     -- Display / Modify NetRom Quality.
        ROUTES(1)      -- Display / Modify NetRom Neighbour Routes.
        XROUTER.CFG(8) -- Main Configuration File.

MAXHOPS(7)                END OF DOCUMENT
