MAXTT(7)               XROUTER REFERENCE MANUAL              25/9/2023

NAME
        MAXTT -- Maximum Trip Time.

SYNOPSIS
        MAXTT=n (n = 0-60000)

AVAILABILITY
        Used only in XROUTER.CFG.

DESCRIPTION
        MAXTT is a global and PORT configuration keyword used in
        XROUTER.CFG, and a parameter which can be used in a ROUTE ADD
        command.

        It defines the maximum accepted "trip time" (transit time) for
        new nodes table entries received via INP3 unicasts from
        neighbours.  Node information with trip times that exceed this
        figure are not accepted into the nodes table.  This parameter
        has no effect on data received via conventional NetRom nodes
        broadcasts.

        MAXTT would typically be used to limit the "trip time horizon"
        to a smaller value than the default horizon, which is 60000
        (600 seconds).  Like MAXHOPS, it can be used to limit the
        number of node entries that are accepted via a particular port
        or neighbour.

        For example, if an RF user lists a moderately sized nodes
        table via an average 1200 baud RF link, it could take several
        minutes to download the data.  It becomes impractical to use
        the "N" commands in that situation.  Experience has shown that
        a nodes table with more than 150 entries is impractical for RF
        users.  Since Internet-based routers have low trip times to
        everywhere, they tend to have very large nodes tables.  Thus
        routers on the Internet<>RF interface, and their RF
        neighbours, would also have over-sized tables, comprised
        mainly of Internet-routed nodes.  Many of these nodes are in
        foreign-language countries of no interest to the RF user.  The
        sysop may choose to limit the horizon to reduce the number of
        Internet nodes in the table.

        Alternatively (and more likely since there are so few RF nodes
        nowadays), a sysop may decide that nodes with trip times of
        more than 10 seconds are too slow, and not worth having in
        the table, and would therefore set a MAXTT of 1000.

        MAXTT can be used in 3 places:  If used in the "global"
        section of XROUTER.CFG, it specifies a default value for all
        ports, overriding the default of 60000.  If used in a PORT
        configuration block, it overrides the global default.  All
        new routes inherit this value.  Finally the port default can
        be overridden for individual routes using by "locking-in" the
        route at the end of XROUTER.CFG, or by a ROUTE ADD command in
        the XRNODES file or at the command prompt. For example:  

                ROUTE ADD g8pzt 5 100 ! 0 0 0 2000 5

        This adds a locked in route to neighbour "g8pzt" on port 5,
        quality 100, with default maxframe, paclen and frack, MAXTT
        of 2000 and MAXHOPS of 5.

        Setting a route's MAXTT to 0 effectively blocks all INP3
        activity.  It disables INP3 unicasts, and ignores received
        INP3.  This is not recommended, but NetRom purists may wish
        to do it anyway.

CAVEATS
        Using MAXTT to limit the no. of nodes learned via a neighbour
        may fail if the neighbour duplicates the INP3 data in
        conventional NetRom nodes broadcasts.  This may enter nodes
        which are beyond your chosen trip time horizon into the nodes
        table and keep them refreshed.  The only defence is to ignore
        data from NetRom broadcasts by setting the port QUALITY below
        MINQUAL, or to set the MINQUAL high.  Both actions may cause
        the  loss of some NetRom-only nodes from the table.

SEE ALSO
        INP3(9)        -- InterNode Protocol
        MAXHOPS(7)     -- Maximum Hop Count.
        MINQUAL(1)     -- Display / Set port Minimum Quality
        QUALITY(1)     -- Display / Modify NetRom Quality.
        ROUTES(1)      -- Display / Modify NetRom Neighbour Routes.
        XRNODES(8)     -- Nodes / Routes Recovery File.
        XROUTER.CFG(8) -- Main Configuration File.

MAXTT(7)                  END OF DOCUMENT
