MHEARD(7)             XROUTER REFERENCE MANUAL               21/9/2023

NAME
        MHEARD -- Enable MHeard & set size.

SYNOPSIS
        MHEARD=<size> (where <size> is a number between 0 and 50)

DESCRIPTION
        MHEARD is an optional directive which may be used in PORT
        defininition blocks in XROUTER.CFG. If present, it specifies
        the MHEARD size for that port.

        Specifying a <size> of zero, or omitting the directive,
        disables MHEARD on that port.

        The maximum size is currently 50 slots, to discourage the
        sending of ridiculously long MHeard lists on congested RF
        channels. If you have a requirement for more, please say so.

        The size of the MHeard list may be changed during run-time
        using the MHSIZE command.

EXAMPLES
        MHEARD=10 ; Enable MHeard, 10 callsigns max
        MHEARD=0  ; Disable MHeard

SEE ALSO
        MHCLEAR(1)     -- Clear MHeard list.
        MHEARD(1)      -- List recently heard stations.
        MHFLAGS(1)     -- Display / Set MHeard options.
        MHSIZE(1)      -- Adjust size of MHeard list.
        MHFLAGS(7)     -- MHeard option flags directive.
        XROUTER.CFG(8) -- Main Configuration File.
        MHEARD(9)      -- About "Monitor Heard".

MHEARD(7)                 END OF DOCUMENT
