MHEARD(9)               XROUTER REFERENCE MANUAL            18/10/2023

NAME
        MHEARD -- "Monitor Heard".

DESCRIPTION
        MHEARD is another legacy command name from early TNC days.

        The MHEARD facility lists recently heard stations, and may be
        enabled or disabled for any port.  It records callsigns in
        reverse order of reception, with the most recent at the top of
        the list, along with other useful information, such as the
        date/time, position, type, and the number of frames heard.

        This allows sysops and users alike to discover who else the
        node can hear, to aid the search for suitable digipeaters, and
        to diagnose problems. 

        Even on linking-only ports, where there is only usually one
        partner, it provides a useful indication when the frequency
        is being encroached upon, either by deliberate squatting,
        unauthorised attempts to link, or lift conditions.

        It is therefore recommended that you enable MHEARD on all
        ports, and indeed this is the default.  The ability to disable
        MHEARD (to save memory) was necessary in DOS XRouter, but
        memory is not an issue in Windows and Linux versions. 

        If you have set your LOCATOR, or have included an APRS-style
        position report in your ID beacon, XRouter will know its own
        position and will display position, distance and bearing for
        any stations which broadcast APRS positions.  This is a great
        aid to network mapping, and it would be nice if everyone were
        to add APRS positions to their ID beacons.

        If a station was heard via a digipeater, the digipeater call
        is also shown, and the letter "D" is shown in the "type"
        field.  If the heard station is a node, the letter "N" is
        displayed. If it is sending IP traffic, "I" is shown, and if
        it is sending ARP traffic, "A" is shown.

        Within XROUTER.CFG, the "MHEARD=n" directive is used in each
        PORT definition block to enable or disable the MHEARD facility
        and to set the size of the list.  For example "MHEARD=50",
        enables it and sets the table size to record a maximum of 50
        callsigns.  If the directive is omitted, the default size is
        15 callsigns.

        You can control which types of station are recorded in the MH
        list using the "MHFLAGS=n" directive in XROUTER.CFG, or by
        using the MHFLAGS command during run-time.  The default value
        for n is 255 (show everything), and the number is formed by
        adding numbers representing the desired options as follows:

           1   Record directly heard stations
           2   Record directly heard digipeaters
           4   Record digipeated stations
           8   Record direct/digipeated separately for each station
          16   Preserve MHeard list across reboot

        For example "MHFLAGS=3" would show directly heard stations and
        digipeaters, but not the stations heard via digipeaters.

        If the "Preserve MHeard lists across reboot" option is set,
        the PORTs MHEARD list is saved to disk at exit and re-loaded
        at startup. The list is also saved at regular intervals. 

        A port's mheard list may be cleared by using the
        "MHCLEAR <port-number>" command.  You may clear all MH lists
        by specifying port 0.

        The MHEARD list is available to sysops and users alike, using
        the MH command (see command reference section).

SEE ALSO
        DX(1)          -- DX list.
        J(1)           -- Recent Sessions.
        MHCLEAR(1)     -- Clear MHeard list.
        MHEARD(1)      -- Display recently heard stations.
        MHFLAGS(7)     --  Set MHeard options.
        MHSIZE(1)      -- Adjust size of MHeard list.
        MHEARD(7)      -- MHeard size/enable directive
        XROUTER.CFG(8) -- Main Configuration File.

MHEARD(9)                   END OF DOCUMENT
