MHEARD(1)             XROUTER REFERENCE MANUAL               21/9/2023

COMMAND
        MHEARD -- List recently heard stations.

SYNOPSIS
        MH[eard] [nodecall] <portnum | ALL>

AVAILABILITY
        The MHEARD command is available to all users.

DESCRIPTION
        If the facility is enabled on the specified port, the MHEARD 
        command lists the most recently heard stations on that port, 
        along with the date / time of reception, the number of frames
        heard, and various other information (see below).

        This is useful for users to discover who else the router can 
        hear, to aid the search for suitable digipeaters, and to 
        diagnose problems.  Even on linking-only ports, where there is 
        only usually one partner, it provides a useful indication when 
        the frequency is being encroached, either by deliberate 
        squatting, unauthorised attempts to link, or lift conditions.

        The command may be abbreviated to "MH".

OPTIONS
        A <portnum> of zero lists the ports which have MH enabled.

        If the first argument is the callsign or alias of a known
        node, the MHeard list of that node is requested, provided the
        target node is XRouter v502s or later. In this case, the
        second argument specifies the port number on the target node.
        If a second argument is not supplied, or is 0 (zero), the
        MHeard-enabled ports on the target node are listed.

        If <portnum> is replaced by the word "ALL", e.g. "MH ALL" or
        "MH KIDDER ALL", the response is a single MHeard list,
        containing up to 100 entries from all MH-enabled ports, with
        the most recently heard at the start of the list

EXAMPLES
        MH 3          - Display heard list for port 3 on this node
        MH ALL        - Display heard list for all ports on this node
        MH KIDDER 16  - Display heard list for port 16 on KIDDER node
 
        G8PZT:KIDDER} Heard list for port 3:
        Callsign  Date  Time Frames  Via     Type  Position  Dist Dir
        G1LOA-10  09/06 13:42   309          DNIA  5221.51N... 13  24     
        G3TQG-2   09/06 13:19   599          D
        GB7PZT-15 09/06 13:18   708
        DY25      09/06 10:19   4    GB7DY-1  N

        Date     - Date when this callsign was last heard.
        Time     - Time when this callsign was last heard.
        Frames   - Total no. of frames heard from this callsign.
        Via      - Digipeater relaying this station, direct if blank.
        Type     - Flags as follows:
                   D - This station is a digipeater
                   N - This station is a node
                   I - This station handles IP traffic
                   A - This station handles ARP traffic
        Position - Position derived from APRS broadcast
        Dist     - Distance calculated from APRS broadcast
        Dir      - Bearing in degrees, calculated from APRS broadcast

FILES
        For each port, the MH facility can be enabled / disabled and 
        the maximum length of the list specified by appropriate 
        entries in the PORT sections of the XROUTER.CFG file,
        e.g. "MHEARD=15" - Sets MH list size 15
             "MHEARD=0"  - Disables MH list

SEE ALSO
        MHCLEAR(1)     -- Clear MHeard list
        MHFLAGS(1)     -- MHeard configuration flags
        MHSIZE(1)      -- Adjust size of MHeard list
        MHEARD(7)      -- Mheard enable/size directive.
        MHEARD(9)      -- "Monitor Heard".
        XROUTER.CFG(8) -- Main Configuration File.  

MHEARD(1)                   END OF DOCUMENT
