;*************************** Max Width *******************************
MINQUAL(7)             XROUTER REFERENCE MANUAL              25/9/2023

NAME
        MINQUAL -- Minimum Quality to Add to Nodes Table.

SYNOPSIS
        MINQUAL=n (where n is in the range 0 to 255)

DESCRIPTION
        MINQUAL is an optional global and PORT directive used in
        XROUTER.CFG.

        It specifies the minimum Net/rom "quality" a node must
        have, in order to be accepted into the nodes table.

        The "global" MINQUAL is inherited by all PORTs subsequently
        defined, unless explicitly overridden by a port MINQUAL.

        When "nodes" broadcasts are received on a port, the "quality"
        of each node thus learned is "de-rated" by an amount
        dependent on the port's QUALITY figure. If the de-rated
        quality is less than the port MINQUAL, the node is not
        accepted into the table.

        This can be used to exclude unreachable and marginal nodes,
        but must be used with care.

EXAMPLE
        MINQUAL=100   ; No nodes less than quality 100 

SEE ALSO
        MINQUAL(1)     -- Display / Set port minimum quality
        PORTS(6)       -- Ports in XRouter.
        QUALITY(7)     -- NetRom Quality
        XROUTER.CFG(8) -- Main Configuration File.

MINQUAL(7)                  END OF DOCUMENT
