MMASK(1)                XROUTER REFERENCE MANUAL            16/10/2023

COMMAND
        MMASK -- Select which protocol(s) to monitor (trace)

SYNOPSIS
        MM[ASK] [0 - FFFFh]

AVAILABILITY
        The MMASK command is available only to console and remote 
        sysops.

DESCRIPTION
        The MMASK command selects which protocol layers will be 
        monitored when traffic tracing is enabled on the current
        console.

        The optional argument is a HEX number between 0000h and FFFFh, 
        which is calculated by adding together the desired values from 
        this table:

           0001 - Incoming frames          0100 - TCP
           0002 - Outgoing frames          0200 - UDP
           0004 - Data payloads            0400 - KISS
           0008 - AX25 layer 2             0800 - SLIP/PPP
           0010 - Net/Rom                  1000 - Ethernet
           0020 - ARP                      2000 - PASSALL
           0040 - IP frames                4000 - Hex Dump
           0080 - ICMP

        If no argument is supplied, the current setting is reported.

        The default setting for the first console is 03FF, which 
        displays all incoming and outgoing traffic from AX25 layer 2 
        upwards. The settings for each console are independent.

        This command duplicates the function of the <F4> key.

        The console can override a remote sysop's settings.

        The PASSALL option enables frames which fail the validity 
        checks at one layer (e.g. KISS checksum) to be passed to the 
        next layer above for tracing.

EXAMPLES
        MMASK 0101  -  display incoming TCP frames only, 
        MMASK 0142  -  display outgoing TCP and IP frames.

LIMITATIONS     
        Remote sysops cannot trace activity on the port on which they 
        are uplinked

NOTE
        Remote sysops must ensure that their link with the router is 
        capable of carrying the large volume of traffic resulting from 
        tracing.  Attempting to trace too many ports / too much detail 
        on a slow link may result in poor performance.  You have been 
        warned!

SEE ALSO
        MONITOR(1) -- Enable / disable monitoring.
        MPORT(1)   -- Select port(s) to monitor.
        MTO(1)     -- Selective monitoring

MMASK(1)                    END OF DOCUMENT
