MOD128(9)               XROUTER REFERENCE MANUAL            18/10/2023

NAME
        MODULO128 -- AX25 Modulo-128.

DESCRIPTION
        Modulo-128 is an extension to AX25, with sequence numbers
        from 0 to 127 instead of the usual 0 to 7.  This allows a
        much bigger MAXFRAME (up to 63) to be used, and is primarily
        of use on good links.

        On conventional (Modulo-8) AX25 links, much of the
        inter-node traffic consists of short frames containing level
        4 control information. These frames are interspersed with
        data-bearing frames, which themselves may be only partially
        full.  Thus a router may transmit 7 frames in one go, but
        the transmission may only be a few hundred bytes in total.

        This is inefficient, due to the delays associated with
        channel access, TXDELAY, TXTAIL, RESPTIME etc.  On fast,
        error-free links the data arrives in short bursts, separated
        by long gaps of inactivity.

        With Modulo-128, many more frames can be packed into a
        single transmission, so the channel overheads become less
        significant.  

        Because the largest allowed MAXFRAME value for Modulo-128
        is 63, there can never be any sequence number ambiguity, and
        this allows frame "re-sequencing", or "selective reject".

        With normal AX25, if the first frame of a multi-frame set is
        lost, the whole set of frames must be re-transmitted.

        If Modulo-128 is used however, the "good" frames are stored
        by the recipient, and only the lost frame is re-sent.
        Together with the stored frames, this completes the set, and
        the whole set can be acked.  This is a much more efficient
        strategy.

        XRouter is capable of both Modulo-128, and frame
        resequencing.

        Modulo-128 frames are displayed on the trace screen as
        "EAX25" (Extended AX25) instead of "AX25", and are initiated
        by a new frame type "SABME" (Set Asynchronous Balanced Mode
        Extended).  You will notice the sequence numbers being
        displayed as "<I R25 S32>"

        The method of activation isn't fully decided as yet.  If a
        caller requests Modulo-128 (by sending an SABME frame),
        XRouter will respond with <UA> and go into Modulo-128 mode.

        The strategy for outgoing links is more complex.  If the
        port MAXFRAME is greater than 7, *ALL* level 2 downlinks on
        that port will be tried using Modulo-128 (i.e. XRouter will
        send <SABME> instead of <SABM>.  This is not on user ports,
        since hardly any users are EAX25 compatible.

        If the called system is Modulo-128 capable, the correct
        response to <SABME> is <UA>, otherwise the correct response
        according to the AX25 protocol is either <DM> or <FRMR>,
        which will cause XRouter to fall back to normal Modulo-8
        AX25.

        Most systems do answer correctly, but there may however be
        some systems which do not properly implement AX25, for
        example by silently discarding <SABME> frames, and it will
        not be possible to link to these systems if MAXFRAME is
        greater than 7.  This may be addressed in a future version.

        It is more likely that Modulo-128 would be used on
        inter-node links with other XRouters, Linux and PE1CHL nodes,
        so to activate it, simply define a MAXFRAME > 7 for those
        routes which require it. If the port is dedicated to one
        link, you can set the port MAXFRAME > 7 instead.

SEE ALSO
        ROUTES(1)      -- NetRom Route commands.
        MAXFRAME(7)    -- Maximum Unacked AX25 Frames Directive.
        XROUTER.CFG(8) -- Main Configuration File.

MOD128(9)                   END OF DOCUMENT
