MONITOR(1)              XROUTER REFERENCE MANUAL            16/10/2023

COMMAND
        MONITOR -- Enable / disable traffic monitoring (tracing)

SYNOPSIS
        MON[ITOR] [on | off]
        MON[itor] IDS [on | off]

AVAILABILITY
        Console and remote sysops only.

DESCRIPTION
        The MONITOR command is primarily used to enable or disable
        the display  of incoming and outgoing traffic.

        The optional argument may be "ON", "OFF" or "IDS".  The
        first enables the display, the second disables it, and the
        third controls Intrusion Detection System monitoring.  If no 
        argument is supplied, the current setting is reported.

        If used at the console, this command enables and disables 
        tracing to the current console window, and works in
        conjunction with the <F2> (monitor toggle) key.

        If used by a remote sysop, there's a chance that the volume   
        of monitored data could overload the link, so the MPORT
        setting is cleared every time monitoring is enabled. The
        sysop must then issue the MPORT command to  select which
        port(s) to monitor.

        The MON IDS [on | off] sub-command controls IDS monitoring as
        follows:

        If MON is ON *and* MON IDS is ON, IDS warnings are echoed to
        the console (or remote monitoring session if you are logged
        on remotely). This allows you to keep an eye on the IDS while
        doing other things.

        This was mainly intended for use on remote monitorng
        sessions, so the default for a *remote* monitor session is
        ON. The default for consoles is OFF.

EXAMPLES
        MON ON     - Enable tracing.
        MON OFF    - Disable tracing.
        MON IDS    - Show current state
        MON IDS ON - Enable IDS warnings

LIMITATIONS
        To prevent infinite recursion, remote sysops are prevented
        from tracing activity on the port on which they are uplinked.
        This is not entirely foolproof, especially where the egress
        port may be uncertain (e.g a netrom or tunneled connection).

NOTE
        Remote sysops must ensure that their link with XRouter is 
        capable of carrying the large volume of traffic resulting
        from tracing.  Attempting to trace too many ports / too much
        detail on a slow link may result in poor performance.

SEE ALSO
        CAPTURE(1) -- Enable / disable tracing to disk file.
        MPORT(1)   -- Select port(s) to monitor.
        MMASK(1)   -- Select type of activity to monitor.
        MTO(1)     -- Selective monitoring

MONITOR(1)                    END OF DOCUMENT
