MPORT(1)                XROUTER REFERENCE MANUAL            18/10/2023

COMMAND
        MPORT -- Select which port(s) to monitor (trace)

SYNOPSIS
        MP[ORT] [0-FFFFFFFF | p+p+p | ALL | NONE]

DESCRIPTION
        The MPORT command selects which port(s) will be monitored
        when traffic tracing is enabled.

        The optional argument is either a HEX number between 0 and
        FFFFFFFF, a list of port numbers concatenated with "+", or
        the words ALL or NONE.

        If no argument is supplied, the current setting is reported.
 
        The hex form is preferable when monitoring is to be enabled
        on many ports at once, but it only works up to port 31.
        The hex value is calculated by adding together the desired
        values from this table (see MORE INFO for details of hex
        arithmetic):

            Port HEX    Port HEX     Port HEX     Port HEX
            ---------------------------------------------------
             0    1      8   100     16  10000    24   1000000
             1    2      9   200     17  20000    25   2000000
             2    4     10   400     18  40000    26   4000000
             3    8     11   800     19  80000    27   8000000
             4   10     12  1000     20 100000    28  10000000
             5   20     13  2000     21 200000    29  20000000
             6   40     14  4000     22 400000    30  40000000
             7   80     15  8000     23 800000    31  80000000

        The P+P+P form is preferable when selecting a small number
        of ports to momitor, or when monitoring ports above 31. 

        This command duplicates the function of the <F3> key.

        When a remote sysop enables tracing, the MPORT setting is
        cleared to NONE, to avoid overloading the link with traffic
        which might otherwise prevent him from issuing further
        commands. The remote sysop must therefore always issue the
        MON ON command first, followed by the MPORT command to select
        which port(s) to monitor.

        The console can override a remote sysop's settings.

EXAMPLES
        MPORT 800  -  Trace port 11.
        MPORT 1803 -  Trace ports 12, 11, 2 and 1.
        MPORT 1+5+39 - Trace ports 1, 5 and 39

NOTES
        Port zero is a "pseudo-port" used to trace traffic coming
        and going via the operating system's TCP/IP stack. So
        "MPORT 0" traces port 0, instead of disabling tracing. You
        must use "MPORT NONE" to disable tracing - or just use
        MON OFF.

LIMITATIONS      
        Remote sysops are prevented from tracing activity on the
        port on which they are uplinked, because this would cause
        an endless loop.

        Ports > 31 can only be traced using the P+P+P argument form.

CAVEATS
        Remote sysops must ensure that their link with XRouter is 
        capable of carrying the large volume of traffic resulting
        from tracing.  Attempting to trace too many ports or too
        much detail on a slow link may result in poor performance.

AVAILABILITY
        The MPORT command is available only to console and remote 
        sysops. It may be used in BOOTCMDS.SYS.

MORE INFO
        Hexadecimal arithmetic is based on powers of 16, and uses
        numbers 0-9 and letters A-F to represent numbers up to 15
        as follows: 

            Hex: 0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F  
            Dec: 0  1  2  3  4  5  6  7  8  9 10 11 12 13 14 15

        Single "digits" are added / subtracted in the usual way,
        except for the fact that letters represent 10-15, therefore:

            The result of adding 1 and 4 is (unsurprisingly) 5
            The result of adding 4 and 8 is C (decimal 12)
            The result of subtracting 8 from F (decimal 15) is 7

        Things get more complicated when the result of a calculation
        is greater than 15, but fortunately that never happens when
        adding MPORT values.

        To create a composite MPORT value, simply add the desired
        values from each column. For example, to monitor ports 1,2,3
        6 and 7, the hex values 02, 04, 08, 40, and 80 must be added.

           02
         + 04
         + 08
         + 40  (note this is "Four zero", not "forty")
         + 80  (eight zero means "8 times 16 plus zero")
        ------
         = CE  (the decimal equivalent is (12*16)+14 = 206)
        ------

SEE ALSO
        MONITOR(1)      -- Enable / disable monitoring.
        MMASK(1)        -- Select type of activity to monitor.
        MTO(1)          -- Selective monitoring
        BOOTCMDS.SYS(8) -- Commands to Execute at Bootup.

MPORT(1)                    END OF DOCUMENT
