;***********************|****|* Max Width *|***|*********************|
MQTT-BLOG(9)            XROUTER REFERENCE MANUAL             26/9/2023

NAME
        MQTT-BLOG -- MQTT Interface to Sysop's Blog.

DESCRIPTION
        The sysop's blog may be operated via XRouter's inbuilt MQTT
        broker, and/or via an external broker, by subscribing or
        publishing to certain topics.

        This facility is incomplete. The curently available
        functionality is documented in the next section.

OPTIONS
        a) Receive Notifications of Blog Events:
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        Topic: xrouter/event/{nodecall}/blog

        The payload of an event notification is an un-named JSON
        object containing the following fields:

        Name          Type      Description
        -----------------------------------------------------------
        "id"          integer   Article/post number.
        "rcvd"        string    Date/time of message creation (*).
        "size"        integer   Length of the blog text in bytes.
        "from"        string    Callsign of the post's creator.
        "subject"     string    Topic of the post (32 chars max)
        "text"        string    Body of the post (plain ASCII)
        "event"       string    Type of event ("posted" or "deleted")

        (*) in format "1997-09-14T23:47:00Z"

        b) Retrieve a Blog Post:
        ~~~~~~~~~~~~~~~~~~~~~~~~

        Topic: xrouter/get/{nodecall}/blog/msg/{msgnum} 

        The response payload is an un-named JSON object containing
        the following fields:

        Name          Type      Description
        -----------------------------------------------------------
        "id"          integer   Article/post number.
        "rcvd"        string    Date/time of message creation (*).
        "size"        integer   Length of the blog text in bytes.
        "from"        string    Callsign of the post's creator.
        "subject"     string    Topic of the post (32 chars max)
        "text"        string    Body of the post (plain ASCII)

        (*) in format "Mon, 14 Sep 1997 23:47:00 GMT"


        c) Post a Blog Article / Reply:
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        Topic: xrouter/put/{nodecall}/blog

        The payload must be a JSON object containing the following
        fields:

        Name          Type      Description
        -----------------------------------------------------------
        "sender"      string    Callsign of sender
        "replyto"     integer   No. of msg being replied to (0=new)
        "subject"     string    Subject of the post (32 chars max)
        "text"        string    Body of the post (unlimited size)

        Response: None unless QOS > 0

LIMITATIONS
        The blog's MQTT interface does not yet notify "like" events,
        nor does it allow article listings, deletion, "liking", or
        the retrieval of replies. Those functions will be added in a
        future version

SEE ALSO
        BLOG(1)      -- Access Sysop's Blog.
        BLOGFLAGS(7) -- Options For Sysop's Blog.
        REST-BLOG(9) -- REST Interface to Blog.
        MQTT-CLI(9)  -- MQTT Client
        MQTT-SRV(9)  -- MQTT Server / Broker.

MQTT-BLOG(9)                 END OF DOCUMENT
