;***********************|****|* Max Width *|***|*********************|
MQTT-CHAT(9)            XROUTER REFERENCE MANUAL             26/9/2023

NAME
        MQTT-CHAT -- MQTT Interface to Chat Server.

DESCRIPTION
        The chat server may be operated via XRouter's inbuilt MQTT
        broker, and/or via an external broker, by subscribing or
        publishing to certain topics.

        This facility is incomplete. The curently available
        functionality is documented in the next section.

OPTIONS
        a) Receive Notifications of Chat Events:
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        These events are published by XRouter whenever someone
        joins or leaves a channel, changes name, personal text or
        channel topic, or sends a nmessage.

        Subscribe Topic: xrouter/event/{nodecall}/chat/{event-type}

        Event-types are:

            join    User joins a channel
            leave   User leaves a channel
            name    User sets or changes name
            pers    User sets or changes personal text
            topic   User sets or changes channel topic
            msg     User sends a chat message

        The payload of an event notification is an un-named JSON
        object containing the following fields:

            Name      Type     Description
            -----------------------------------------------------
            "user"    string   Callsign of user
            "host"    string   Alias of chatserver the user is on
            "name"    string   User's name
            "time"    string   Time of event in form HH:MM
            "channel" number   Channel number (*1)
            "topic"   string   Topic name for channel (*2)
            "pers"    string   Personal text (*3)
            "reason"  string   Reason for leaving channel (*4)

            (*1) "channel" not present in "name" or "pers" events
            (*2) "topic" only present in "topic" events
            (*3) "pers" only present in "pers" events
            (*4) "reason" only present in "leave" events

        Internally the event time is stored as a 32bit unsigned
        integer, representing the number of seconds since 1/1/70. It
        could be sent as a number instead of a string, if that was
        easier for the consuming client?

        Channel numbers can range from -32767 to +32767. Negative
        channels are used for Tampa Ping Pong chat. Channel 101 is
        BPQ (W0RLI's RoundTable) chat. Channel numbers between 0 and
        999, except 101, are local only. Channels > 999 are
        distributed to all XRChat servers.


        b) List Chatserver Channels and Users:
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        If the client publishes a "get" request, XRouter responds by
        publishing the requested data to a similar "status" topic.

        Request Topic:  xrouter/get/{nodecall}/channels

        Response Topic: xrouter/status/{nodecall}/channels

        The response payload is a JSON array, which may be empty. If
        present, each array element (channel) has at least the
        following fields:

            Name      Type     Description
            ----------------------------------------------------
            "number"  number   Channel number (-32767 to 32767)
            "topic"   string   Channel topic, e.g. "RoundTable"
            "users"   array    List of users on the channel

        The "users" array may be empty. If any users are present, a
        user array element contains the following fields:

            Name      Type     Description
            ----------------------------------------------------
            "user"    string   User ID (usually callsign)
            "host"    string   Alias of their chat server
            "name"    string   User's name
            "idle"    string   Elapsed time since activity
            "stat"    string   Short presence/status text
            "pers"    string   Personal text
            "qth"     string   Home town

        Some fields may be empty, e.g. personal text and QTH.

        Idle time is "0s" to "59s", then "1h" to "23h", then "1d"
        upwards.

        Short presence/status codes are:

            "Offline"   Not on chat
            "Avail"     Available to chat
            "Busy"      Possibly watching, but likely too busy to reply
            "BRB"       Be Right back - very short break
            "Away"      Away from computer for a while
            "Lunch"     Out to lunch
            "Phone"     On the phone, will be back
            "D.N.D"     Do Not Disturb. Don't involve me
            "Asleep"    Gone to bed, so not watching live
            "In&Out"    Reading and responding intermittently

        Example:

            pub xrouter/get/G8PZT-1/channels

            xrouter/status/G8PZT-1/channels
            [
            {
            "number": 101,
            "topic": "RoundTable",
            "users": [
                 ]
            },
            {
            "number": 1000,
            "topic": "Welcome",
            "users": [
            "user": "G8PZT-4",
            "host": "MOBCHT",
            "name": "Paula",
            "idle": "1m",
            "stat": "Avail,",
            "pers": "Programming again!"
            "qth": "kidderminster"
                  ]
            },
            {
            "number": 1234,
            "topic": "Sysop Chat",
            "users": [
                   ]
            }
            ]


        c) Post a Chat Message:
        ~~~~~~~~~~~~~~~~~~~~~~~

        Publish Topic: xrouter/put/{nodecall}/chat

        The payload must be a JSON object containing the following
        fields:

            Name        Type      Description
            ------------------------------------------------------
            "sender"    string    Callsign of sender
            "channel"   number    Destination channel
            "name"      string    Sender's name
            "text"      string    Body of the message

        Channel numbers can range from -32767 to +32767. Negative
        channels are used for Tampa Ping Pong chat. Channel 101 is
        BPQ (W0RLI's RoundTable) chat. Channel numbers between 0 and
        999, except 101, are local only. Channels > 999 are
        distributed to all XRChat servers.

        Response: None unless QOS > 0

LIMITATIONS
        The chat MQTT interface is only a proof-of-concept at this
        stage, and some details may change. More functionality will
        be added in a future version.

SEE ALSO
        CHAT(1)      -- Connect to Chat Server.
        CHAT-SRV(9)  -- About the chat server.
        MQTT-CLI(9)  -- MQTT Client
        MQTT-SRV(9)  -- MQTT Server / Broker.

MQTT-CHAT(9)                 END OF DOCUMENT
