;***********************|****|* Max Width *|***|*********************|
MQTT-PMS(9)             XROUTER REFERENCE MANUAL             26/9/2023

NAME
        MQTT-PMS -- MQTT Interface to Personal Message System.

DESCRIPTION
        The PMS may be operated via XRouter's inbuilt MQTT
        broker, and/or via an external broker, by subscribing or
        publishing to certain topics.

        This facility is incomplete. The curently available
        functionality is documented in the next section.

OPTIONS
        a) Receive Notifications of PMS Message Events:
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        These events are published by XRouter whenever someone
        creates, reads, or kills a message, and when a message is
        delivered to the recipient's PMS.

        Subscription Topic: xrouter/event/{nodecall}/pmsg

        The payload of an event notification is an un-named JSON
        object containing the following fields:

            Name      Type      Description
            -----------------------------------------------------
            "number"   integer   Message number.
            "mid"      string    Message ID (MID or BID)
            "rcvd"     string    Date/time of message reception (*1).
            "size"     integer   Length of the message body in bytes.
            "type"     string    Type of message: (A, P, B, E, T etc)
            "status"   string    Message status: (R, F, U etc) (*2)
            "to"       string    Destination address (*3)
            "from"     string    Callsign of the message's creator.
            "subject"  string    Message subject (32 chars max)
            "event"    string    Event type (*4)

        (*1) in format "1997-09-14T23:47:00Z"
        (*2) type and status may in future be unambiguous words
        (*3) e.g. "g8pzt", "all@gbr", "g8pzt@gb7pzt.#24.gbr.eu"
        (*4) event types are as follows:

             "newmsg"    New message	
             "fwded"     Message has been forwarded
             "read"      Message has been read
             "killed"    Message has been killed

        Example:

            {
            "number": 117,
            "mid": "47DCE8A17PZT"
            "size": 67,
            "type": "P",
            "to": "G8PZT@DOTPMS",
            "from": "G9DUM",
            "subject": "test 1",
            "event": "newmsg"
            }


        b) Retrieve a Message:
        ~~~~~~~~~~~~~~~~~~~~~~

        Publish Topic: xrouter/get/{nodecall}/mail/msg/{msgnum} 

        The response payload is an un-named JSON object containing
        the following fields:

        
            Name      Type      Description
            -----------------------------------------------------
            "number"   integer   Message number.
            "mid"      string    Message ID (MID or BID)
            "rcvd"     string    Date/time of message reception (*1).
            "size"     integer   Length of the message body in bytes.
            "type"     string    Type of message: (A, P, B, E, T etc)
            "status"   string    Message status: (R, F, U etc) (*2)
            "to"       string    Destination address (*3)
            "from"     string    Callsign of the message's creator.
            "subject"  string    Message subject (32 chars max)
            "text"     string    Body of the message (*4)

        (*1) in format "1997-09-14T23:47:00Z"
        (*2) type and status may in future be unambiguous words
        (*3) e.g. "g8pzt", "all@gbr", "g8pzt@gb7pzt.#24.gbr.eu"
        (*4) Message body includes all RFC822 and routing headers

        c) Post a Message:
        ~~~~~~~~~~~~~~~~~~

        Publish Topic: xrouter/put/{nodecall}/mail

        The payload must be a JSON object containing the following
        fields:

            Name        Type      Description
            ------------------------------------------------------
            "from"      string    Callsign of sender
            "to"        string    Destination (see below)
            "type"      string    Only "P" or "B" at present
            "subject"   string    Subject of message (32 chars max)
            "text"      string    Body of the message

        For private messages the destination may be just a callsign,
        or <callsign>@<hierarchical-address>. For bulletins it may
        be simply <topic> or <topic>@<distribution>. For email it is
        <user>@<host>.

        Response: None unless QOS > 0

LIMITATIONS
        The PMS's MQTT interface is only a proof-of-concept at this
        stage, and some details may change. More functionality will
        be added in a future version.

SEE ALSO
        PMS(1)      -- Access Personal Message System.
        PMS(9)      -- About the Personal Pessage System.
        REST-PMS(9) -- REST Interface to PMS.
        MQTT-CLI(9) -- MQTT Client
        MQTT-SRV(9) -- MQTT Server / Broker.

MQTT-PMS(9)                  END OF DOCUMENT
