;*************************** Max Width *******************************
MQTT-PUB(9)            XROUTER REFERENCE MANUAL              23/9/2023

NAME
        MQTT-PUB -- MQTT Publisher.

DESCRIPTION
        The MQTT "publisher" is an inbuilt MQTT client daemon which,
        if enabled, automatically connects to an *external* MQTT
        broker (server), and publishes data to it. The broker may be
        on the LAN or in the cloud.

        The broker's IP address or hostname is specified using
        MQTTSERVADDR in XROUTER.CFG, and its TCP port number by
        MQTTSERVPORT, which defaults to 1883. If the broker address
        is not specified (the default condition), or the broker port
        is set to 0, the publisher is disabled.

        If enabled, various information is sent to the broker in JSON
        format, including station configuration, layer 2, 4 and 7
        events such as connections and disconnections, radio control
        events such as PTT, frequency and mode changes, PMS message
        events, chat server events, raw packet data and so on. As
        proof of concept, a web-based chat server interface has been
        demonstrated.

        The term "publisher" is somewhat of a misnomer, as the data
        flow is bi-directional.

        Therefore any client of the external broker may not only
        passively receive "pushed" data from XRouter, but may also
        "push" data to XRouter, and "pull" data from it on request.

        By publishing to "getter" topics, a client may request status
        reports, such as lists of AX25 L2 links, routes, nodes, L4
        circuits, sessions, recent sessions, chat server status,
        MHeard and DX lists etc. 

        By publishing to "putter" topics, a client may also send data
        to the node, such as chat, PMS and control mesages, raw
        packet data etc. Ulitmately it should be possible to provide
        a full MQTT-based interface to packet radio.

        See MQTT-SRV(9) for the list of getter and putter topics.

SEE ALSO
        MQTT-CLI(9)     -- MQTT Client
        MQTT-SRV(9)     -- MQTT Server / Broker
        MQTT-SVC(9)     -- NetRomX MQTT Service
        MQTTSERVADDR(7) -- Hostname / IP of Externam MQTT Broker
        MQTTSERVPORT(7) -- TCP Port for External MQTT Broker
        XROUTER.CFG(8)  -- Main Configuration File.

MQTT-PUB(9)                  END OF DOCUMENT
