;*************************** Max Width *******************************
MQTT-SRV(9)            XROUTER REFERENCE MANUAL              23/9/2023

NAME
        MQTT-SRV -- MQTT Server / Broker.

DESCRIPTION
        XRouter has an inbuilt MQTT broker (server), which allows
        MQTT clients to exchange information with XRouter, with each
        other, and with an external broker.

        The broker may be enabled on XRouter and/or Linux IP stacks
        using the MQTTPORT directive in XROUTER.CFG. The usual TCP
        port number for MQTT is 1883.

        Although primarily intended for use via the LAN, the broker
        is also available via NetRomX service 1883 for anyone who
        wants to experiment with MQTT over radio.

        Clients may "publish" data to "topics", and may "subscribe"
        to topics, in order to receive any data published to that
        topic.

        XRouter automatically publishes "events", both to the
        internal MQTT broker, and if configured to do so, to an
        external broker.

        The information, which is published in JSON format, includes
        station configuration, layer 2, 4 and 7 events such as
        connections and disconnections, radio control events such as
        PTT, frequency and mode changes, PMS message events, chat
        server events, raw packet data and so on. As proof of
        concept, a web-based chat server interface has been
        demonstrated.

        A client may also request status reports, such as lists of
        AX25 L2 links, routes, nodes, L4 circuits, sessions, recent
        sessions, chat server status, MHeard and DX lists etc.

        A client may also send information to the node, such as chat,
        PMS and control mesages. Ultimately it should be possible to
        provide a full MQTT-based interface to packet radio. That bit
        is left up to you!

OPTIONS
        Subscription Topics:
        ~~~~~~~~~~~~~~~~~~~~

        Subscribing to any of the following topics causes XRouter to
        publish data asynchronously, to the same topic:

        xrouter/event/{nodecall}/blog           Sysop's Blog Events
        xrouter/event/{nodecall}/chat/{evtype}  Chat Events
        xrouter/event/{nodecall}/circuit        NetRom L4 Cct Events
        xrouter/event/{nodecall}/link           AX25 Link Events
        xrouter/event/{nodecall}/pmsg           PMS Message Events
        xrouter/event/{nodecall}/radio/{number} Radio Events
        xrouter/event/{nodecall}/session        Session Layer Events
        xrouter/event/{nodecall}/wall           Message "wall" Events
        xrouter/event/{nodecall}/wx[/{call}]    Weather data events
        xrouter/ax25/{nodecall}/rcvd/{portnum}  Raw AX25 Frames Rx'd
        xrouter/ax25/{nodecall}/sent/{portnum}  Raw AX25 Frames Tx'd
        xrouter/ipv4/{nodecall}/rcvd            Raw IPV4 Frames Rcvd
        xrouter/ipv4/{nodecall}/sent            Raw IPV4 Frames Sent
        xrouter/kiss/{nodecall}/rcvd/{ifacenum} KISS Frames Received
        xrouter/kiss/{nodecall}/sent/{ifacenum} KISS Frames Tx'd
        xrouter/nr3b/{nodecall}/rcvd            Netrom Traffic Rx'd
        xrouter/nr3b/{nodecall}/sent            Netrom Traffic TX'd

        Getter Topics:
        ~~~~~~~~~~~~~~

        These are used to obtain information *from* XRouter on demand.
        Publishing to any of these topics elicits a reply from
        XRouter, with "get" replaced by "status" in the topic:
 
        xrouter/get/{nodecall}/blog/msg/{msgnum} Retrieve a blog post
        xrouter/get/{nodecall}/channels     Chat channel occupancy
        xrouter/get/{nodecall}/circuits     Netrom L4 circuits
        xrouter/get/{nodecall}/config       Node Configuration Info
        xrouter/get/{nodecall}/jlist        Recent Sessions
        xrouter/get/{nodecall}/links        AX25 circuits
        xrouter/get/{nodecall}/mheard       Port "MHeard" Lists
        xrouter/get/{nodecall}/nodes        NetRom Nodes Table
        xrouter/get/{nodecall}/node/{call}  Info For Specific Node
        xrouter/get/{nodecall}/recent       Recent chat messages
        xrouter/get/{nodecall}/routes       NetRom Neighbour Routes
        xrouter/get/{nodecall}/users        Current Sessions
        xrouter/get/{nodecall}/wall/msg/{msgnum} Retrieve a wall post


        Putter Topics:
        ~~~~~~~~~~~~~~

        These are used to send information *to* XRouter. They don't
        elicit any response, other than a PUBACK if QOS > 0.

        xrouter/put/{nodecall}/ax25/{portnum}   Send raw AX25  (*1)
        xrouter/put/{nodecall}/blog             Post a blog article
        xrouter/put/{nodecall}/chat             Send a CHAT message
        xrouter/put/{nodecall}/ipv4             Send raw IP datagram
        xrouter/put/{nodecall}/kiss/{ifacenum}  Send raw KISS Frame
        xrouter/put/{nodecall}/nr3b             Send raw NetRom (*2)
        xrouter/put/{nodecall}/wall             Post a wall message
        xrouter/put/{nodecall}/wx               Post local weather data

        (*1) Without HDLC framing or CRC
        (*2) Routable datagrams only, no L3RTT, INP3 or Nodes bcasts!

CAVEATS
        This system is by no means finished. There's a lot more that
        could be done, but it needs someone to actually USE it and
        provide feedback.

SEE ALSO
        MQTT-BLOG(9)   -- MQTT Interface to Sysop's Blog.
        MQTT-CLI(9)    -- MQTT Client
        MQTT-SVC(9)    -- NetRomX MQTT Service.
        MQTT-PUB(9)    -- MQTT Publisher.
        MQTT-WALL(9)   -- MQTT Interface to Message Wall.
        MQTTPORT(7)    -- TCP Port for MQTT Broker.
        XROUTER.CFG(8) -- Main Configuration File.

MQTT-SRV(9)                  END OF DOCUMENT
