;***********************|****|* Max Width *|***|*********************|
MQTT-WALL(9)            XROUTER REFERENCE MANUAL             26/9/2023

NAME
        MQTT-WALL -- MQTT Interface to Message Wall.

DESCRIPTION
        The message "wall" may be operated via XRouter's inbuilt MQTT
        broker, and/or via an external broker, by subscribing or
        publishing to certain topics.

        This facility is incomplete. The curently available
        functionality is documented in the next section.

OPTIONS
        a) Receive Notifications of Wall Events:
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        Topic: xrouter/event/{nodecall}/wall

        The payload of an event notification is an un-named JSON
        object containing the following fields:

        Name          Type      Description
        -----------------------------------------------------------
        "id"          integer   Article/post number.
        "rcvd"        string    Date/time of message creation (*).
        "size"        integer   Length of the text portion in bytes.
        "from"        string    Callsign of the post's creator.
        "text"        string    Body of the post (plain ASCII)
        "event"       string    Type of event ("posted" or "deleted")

        (*) in format "Mon, 14 Sep 1997 23:47:00 GMT"

        b) Retrieve a Wall Post:
        ~~~~~~~~~~~~~~~~~~~~~~~~

        Topic: xrouter/get/{nodecall}/wall/msg/{msgnum} 

        The response payload is an un-named JSON object containing
        the following fields:

        Name          Type      Description
        -----------------------------------------------------------
        "id"          integer   Article/post number.
        "rcvd"        string    Date/time of message creation (*).
        "size"        integer   Length of the text in bytes.
        "from"        string    Callsign of the post's creator.
        "text"        string    Body of the post (plain ASCII)

        (*) in format "Mon, 14 Sep 1997 23:47:00 GMT"


        c) Post a Wall Message / Reply:
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        Topic: xrouter/put/{nodecall}/wall

        The payload must be a JSON object containing the following
        fields:

        Name          Type      Description
        -----------------------------------------------------------
        "sender"      string    Callsign of sender
        "text"        string    Body of the post (unlimited size)

        Response: None unless QOS > 0

LIMITATIONS
        The wall's MQTT interface does not yet notify "like" events,
        nor does it allow article listings, deletion, "liking", or
        the retrieval of replies. Those functions will be added in a
        future version

SEE ALSO
        WALL(1)      -- Access Message Wall / Guestbook.
        WALLFLAGS(7) -- Options For Message Wall.
        REST-WALL(9) -- REST Interface to Wall.
        MQTT-SRV(9)  -- MQTT Server / Broker.

MQTT-WALL(9)                 END OF DOCUMENT
