;***********************|****|* Max Width *|***|*********************|
MQTT-WX(9)              XROUTER REFERENCE MANUAL             26/9/2023

NAME
        MQTT-WX -- MQTT Interface to Weather System.

DESCRIPTION
        If XRouter has a source of weather information, e.g. APRS
        broadcasts, local sensors or an online source, weather updates
        can be received from XRouter's inbuilt MQTT broker by
        subscribing to the "weather events" topic, i.e.

            xrouter/event/{nodecall}/wx

        Weather data stored on XRouter can also be retrieved at any
        time using MQTT "get" requests.

        A "get" request is an MQTT "publish" packet with a topic of
        the general form:

            xrouter/get/{nodecall}/{resource}

        Such requests are actioned directly by XRouter and are NOT
        published to other clients.

        The response from XRouter is published to a topic of the
        general form:

            xrouter/status/{nodecall}/{resource}

        The response payload is either a JSON object or a JSON array,
        depending on the requested resource.

        The response is sent only to the client making the request.

        There are curently two possible {resource} types, namely the
        "station ID" of a weather station, or "allwx".  Station ID's
        are usually callsigns, but may take other forms such as
        "LOCAL", "SHED", "SHACK" and so on.

        LOCAL is the primary resource for locally sourced weather
        information.  Unlike the other resources it maintains max/min
        values and times, trends and so on.

        Weather information can also be uploaded to XRouter from a
        local source (e.g. RTL_433), via the MQTT server.

OPTIONS
        a) Receive Notifications of Weather Reports:
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        Subscribe Topic:  xrouter/event/{nodecall}/wx

        The payload of a weather event is an un-named JSON object
        containing some or all of the following fields:

        Name             Type     Description
        -----------------------------------------------------------
        "id"             string   Station id, e.g. "G8PZT" or "LOCAL"
        "lat_deg"        number   Latitude of WX station in degrees
        "lon_deg"        number   Longitude of wx station in degrees
        "dist_km"        number   Distance from our node in kilometres
        "dir_deg"        number   Direction from our node in degrees
        "dt"             integer  Observation time, secs since 1/1/70
        "observed"       string   Date and time of observation (*1) 
        "pressure_mb"    number   Air pressure in millibars
        "temperature_C"  number   Air temperature in degrees C
        "humidity"       number   Relative Humidity in percent
        "dewpoint_C"     number   Dew point in degrees Centigrade
        "heat_index_C"   number   Heat index in deg Centigrade
        "wind_chill_C"   number   Wind Chill in degrees Centigrade
        "wind_mph"       number   Wind speed in miles per hour
        "wind_dir_deg"   number   Wind direction in degrees
        "gust_mph"       number   Wind gust speed in miles per hour
        "raintoday_mm"   number   Total rain since midnight in mm
        "rain1h_mm"      number   Current rainfall rate mm/hour
        "rain24h_mm"     number   Total rain in past 24 hours in mm
        "sunrise"        string   Sunrise time at the station hh:mm
        "sunset"         string   Sunset time at the station hh:mm
        "daylight_hours" number   Hours between sunrise and set

        (*1) As "dt" but human-readable e.g. 2024-03-14T15:19:59Z


        b) Requesting Weather Data From a Specific Station:
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        Publish Topic:  xrouter/get/{nodecall}/wx/{station_id}

        Reply topic:    xrouter/status/{nodecall}/wx/{station_id}

        The reply payload is an anonymous JSON object, containing
        the fields detailed in section (a) above.


        c) Requesting All Available Weather Data:
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        Publish Topic:  xrouter/get/{nodecall}/allwx

        Reply topic:    xrouter/status/{nodecall}/allwx

        The reply payload is an anonymous JSON array, containing zero
        or more JSON objects.  Each object, representing one weather
        station, contains the fields detailed in section (a) above.


        d) Uploading Weather Data To XRouter:
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        Publish Topic:  xrouter/put/{nodecall}/wx

        Payload:    JSON object containing weather data.

        The exact format of the payload is configurable by the sysop,
        to match the fields used by the originating MQTT source.  The
        default values as as follows:

        Name             Type     Description
        --------------------------------------------------------
        "model"          string   Sensor make/model
        "id"             string   Sensor identifier
        "time"           string   Observation time (mandatory) (*1)
        "pressure"       number   Air pressure in millibars
        "temperature_c"  string   Air temperature in degrees C (*2)
        "humidity"       integer  Relative humidity in percent
        "wind_avg_m_s"   string   Wind speed in metres per sec (*3)
        "wind_max_m_s"   string   Gust speed in metres per sec (*3)
        "wind_deg"       string   Wind direction in degrees (*4)
        "rain_mm"        string   Total rainfall in mm (*5)
        "light_lux"      string   Solar Irradiance in lux (*6)
        "uv"             integer  UV level
        "uvi"            integer  UV Index
        "battery_ok"     integer  Sensor battery indication

        (*1) Observation time is mandatory.  Acceptable formats are
             Unix epoch (i.e. secs since 1/1/1970), a date/time like
             "yyyy-mm-dd hh:mm:ss", or "yyyy-mm-ddThh:mm:ssZ". e.g.
             "2024-03-14T15:19:59Z".

        (*2) Temperature defaults to centigrade, unless the value
             string is suffixed by the letter "F" (case independent).
             If the value contains a decimal point, it is assumed to
             be in degrees.  If there is no decimal point, it
             signifies tenths of a degree.  In this mode, negative
             temperatures using either 12-bit or 16-bit "two's
             complement" are accepted.
             e.g. "10.1" and "101" both mean 10.1 degrees Centigrade.
             "50.5F or "505 F" or "50.5 f" all mean 50.5 degrees
             Fahrenheit. "65540" means -1.5 degrees Centigrade if the
             sensor is using 16-bit two's complement.
   
        (*3) Wind speeds default to miles per hour if no units are
             present in either the field name or the value string.
             If the field name contains "m_s" or the value string
             contains "m/s", the units are metres per second.
             If the field name contains "km_h" or the value string
             contains "km/h" the units are kilometres per hour.

        (*4) Wind direction may be specified in whole degrees (0-359),
             or as cardinal points, e.g. "N", "W", "SSE" etc.

        (*5) If the field name contains "mm" or the value contains a
             decimal point, the rainfall units are assumed to be
             millimetres, otherwise they are assumed to be cumulative
             "bucket tips".  The default bucket size of 0.3mm, can be
             changed using the WXBUCKET directive in XROUTER.CFG.

        (*6) Light level defaults to watts per square metre, but can
             be specified in Lux by appending "lux", e.g. "4568 lux".

        The uploaded data is assumed to be from a local sensor, and
        is therefore stored under the station ID "LOCAL".  Future
        versions may allow for extra sensors, as per the REST API.

EXAMPLES
        xrouter/event/G8PZT/wx       - Get weather notifications
        xrouter/get/G8PZT/wx/G6GUH-7 - Retrieve WX data from G6GUH-7
        xrouter/get/G8PZT/allwx      - Retrieve all weather data

SEE ALSO
        WX(1)        -- Display Weather Information.
        WX(9)        -- Weather Information System.
        REST-WX(9)   -- REST Interface to Weather System.
        MQTT-SRV(9)  -- MQTT Server / Broker.

MQTT-WX(9)                   END OF DOCUMENT
