;***********************|****** Max Width *****|*********************|
MQTTPORT(7)             XROUTER REFERENCE MANUAL             27/9/2023

NAME
        MQTTPORT -- TCP Port for MQTT Server/Broker.

SYNPOSIS
        MQTTPORT=n1 [n2] (where n1 and n2 are 0 to 65535)

DESCRIPTION
        MQTTPORT is an optional GLOBAL configuration directive
        used in XROUTER.CFG.

        If present, it specifies the TCP "service port" number for
        XRouter's internal MQTT server/broker. If not present, the
        default is 1883.
 
        The MQTT server (previously known as a "broker") allows MQTT
        clients to exchange information with XRouter, with each
        other, and with an external broker.

        Although primarily intended for use via the LAN, the broker
        is also available via NetRomX service 1883 for anyone who
        wants to experiment with MQTT over radio.

OPTIONS
        If a single argument is supplied, e.g. "MQTTPORT=99", it
        applies to whichever TCP/IP stack(s) XRouter is using.

        If TWO arguments are supplied, e.g. "MQTTPORT=99 9999",
        the first argument applies to the XRouter stack and the
        second to the host system's stack. The numbers must be
        separated by whitespace

        Setting MQTTPORT to zero on a stack prevents TCP connections
        to the broker via that stack.

        See TCP-PORTS(6) for more information on this and the caveat
        below.

CAVEATS
        In order to use port numbers below 1024 on the Linux stack,
        XRouter must be run from a root account, or given the
        CAP_NET_BIND_SERVICE capability.

SEE ALSO
        CAPFLAGS(6)    -- Capability Flags.
        MQTT-SRV(9)    -- MQTT Server/Broker.
        MQTT-SVC(9)    -- NetRomX MQTT Service.
        TCP-PORTS(6)   -- TCP Service Ports.
        XROUTER.CFG(8) -- Main Configuration File.

MQTTPORT(7)           END OF DOCUMENT
