NAT(9)                  XROUTER REFERENCE MANUAL            17/10/2023

NAME
        NAT -- Network Address Translation.

DESCRIPTION

        Section 1 - About Network Address Translation
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        In order for a computer (sometimes called a "host") to
        communicate with other computers using TCP/IP it must have an
        IP address.  This is a 32 bit number unique to that machine,
        and it is composed of four 8 bit fields which hosts use to
        make routing decisions.

        Theoretically, there could be 2**32 unique addresses (just
        over 4000 million), but in practice the figure is a lot lower
        because some of the addresses are not used.  This is due to
        the way addresses are separated into classes and assigned to
        networks.

        For example, the "class A" address series 44.x.x.x is assigned
        to the amateur radio network and contains 2**24 (16.7 million)
        addresses. Within this series, the series 44.131.x.x is
        assigned to the UK, and contains 2**16 (65536) addresses.

        Taking this further, the series 44.131.91.x is assigned to
        north Worcestershire and contains 2*8 (256) addresses, yet
        there are only a couple of IP stations in north
        Worcestershire.  So the remaining IP addresses are "wasted".
        A similar wastage occurs in every county in the UK and every
        country in the world.

        Although there are only a couple of registered IP stations in
        the 44.131.91.x series, each station may be running more than
        one computer. Some of these machines are nothing to do with
        amateur radio and therefore are not entitled to a 44.x.x.x
        series IP address.  In addition, registering IP addresses is a
        lengthy procedure which is impractical for dealing with a home
        network in which computers are rearranged frequently.

        In order to cater for these private and experimental networks,
        a number of address ranges were set aside for "unregistered"
        use.  One such series is 192.168.0.x which can cater for up to
        256 hosts.  Any one of these addresses may be used in millions
        of private networks at once, thus alleviating the shortage of
        IP addresses.

        A problem arises if an "unregistered" host on a private
        network needs to communicate with a host on the "registered"
        network.  Packets from the unregistered (local) host can be
        routed to the registered (global) host, but since the local
        host is unregistered, and the same address is used many places
        at once, the network has no way of knowing where to send the
        replies.

        This is where Network Address Translation (NAT) comes to the
        rescue. NAT operates on each datagram, substituting one IP
        address with another.

        For instance a local address such as 192.168.0.2 can be
        translated to a globally recognised one, such as 44.131.91.2,
        allowing a host on a LAN to access, and be visible to, the
        global network.

        Consider this example:

              Registered IP           Unregistered IP
              44.131.91.2             192.168.0.2
              44.131.91.3             192.168.0.16

        Packets arriving from the global network addressed to
        44.131.91.2 are re-addressed to 192.168.0.2 and routed to the
        appropriate machine on the local network, while those
        addressed to 44.131.91.3 are re-addressed to 192.168.0.16 and
        routed to that machine.

        In the reverse direction, packets originating from host
        192.168.0.2 on the LAN, destined for the global network, have
        their source address changed to the globally recognised
        44.131.91.2, and 192.168.0.16 is translated to 44.131.91.3.

        This one to one mapping of one address to another is called
        STATIC NAT, (also known as RFC1631 NAT) and is implemented in
        Xrouter.


        Port Address Translation
        ~~~~~~~~~~~~~~~~~~~~~~~~
        With Static NAT, if you have more than one local host which
        needs to be visible on the global network, you must own more
        than one registered IP address.  A refinement of NAT, called
        Port Address Translation (PAT) allows one registered IP
        address to be shared by many unregistered hosts, by
        manipulating the "service port" numbers in TCP and UDP packet
        headers.

        For example, consider the following mappings:

              Global address  Port            Local address   Port
              --------------  ----            -------------   ----
              44.131.91.2     777             192.168.0.1     1024
              44.131.91.2     778             192.168.0.2     1024
              44.131.91.2     779             192.168.0.5     1631


        TCP segments originating from port 1024 on local host
        192.168.0.1, and destined for the global network, are
        re-addressed to look like they originated from port 777 on
        the globally-recognised host 44.131.91.3. Likewise, segments
        from port 1631 on local host 192.168.0.5 are made to look like
        they originated from port 779 on global host 44.131.91.2. The
        translations are reversed for incoming segments.

        PAT can be static or dynamic.  With static PAT, the sysop must
        set up the translation table as in the example above.  Dynamic
        PAT builds the table automatically, and the entries are
        removed when they're finished with.  This makes the two
        systems behave very differently, as discussed below.


        Static PAT
        ~~~~~~~~~~
        This form of PAT consistently translates a global address/port
        pair to an equivalent local address/port pair and vice versa.
        Since the mappings are permanent and predictable, the
        designated ports on the local hosts are visible to the global
        network.  This is ideal for making local servers (e.g. SMTP,
        HTTP, POP3) globally visible.

        Static PAT can be used to multiplex several hosts onto one IP
        address, or it can simply be used to manipulate port numbers,
        for example to create "virtual hosts" as shown below:

              Global address  Port            Local Address   Port
              44.131.91.2     80              192.168.0.1     8000
              44.131.91.3     80              192.168.0.1     8001
              44.131.91.4     80              192.168.0.1     8002

        The outside world sees 3 web servers (port 80 is the HTTP
        port), with the IP addresses 44.131.91.2, 91.3 and 91.4, yet
        in reality there are 3 separate web server processes (ports
        8001, 8002, 8003) running on one host.

        There is a problem with static PAT however.  TCP/IP server
        processes use predictable port numbers.  For instance, HTTP
        servers usually use port 80 (although they can often be
        re-configured for a different port), which means that incoming
        TCP segments addressed to port 80 will always go to the web
        server, and the server will reply using the same port as the
        source.

        TCP/IP *clients* on the other hand tend to use unpredictable
        port numbers.  For example, the first Telnet client session on
        a freshly booted Windows98 system will use port 1024, the next
        session will use port 1025 and so on.  With static PAT, set up
        to translate port 1024 to an outside world address/port pair,
        the first Telnet session will succeed, but the second and
        subsequent ones will fail.

        Therefore as a general rule, static PAT is useful for making
        local SERVERS globally visible, but not for accessing the
        global network using local CLIENTS.  It's a one way street.
        This effect can be exploited to prevent LAN users from
        accessing the global network.


        Dynamic PAT
        ~~~~~~~~~~~
        Dynamic PAT is commonly used to multiplex several hosts onto
        one IP address a process called "Overloading", and it tends to
        act as a one way street in the opposite direction to static
        PAT.

        Translation entries are created when a local host originates a 
        connection to the global network, and are removed when that
        connection is closed.  Thus dynamic PAT cannot generally be
        used to make local servers globally visible, but outgoing
        connections can be made without hindrance.

        This creates a simple "firewall", preventing your local hosts
        from attacks from the global network.

        Both static and overloaded PAT are implemented in XRouter.


        Limitations of NAT / PAT
        ~~~~~~~~~~~~~~~~~~~~~~~~
        Unfortunately, NAT and PAT are not completely transparent to
        the user, and there are certain situations which they cannot
        handle.

        IP, ICMP, TCP and UDP packet headers each contain a
        "checksum", and the IP addresses and service port numbers are
        included in the calculation. This means that any change to the
        address or port numbers requires all the checksums to be
        recalculated and re-inserted.

        In most cases it is sufficient to manipulate the packet
        headers alone, but some protocols convey IP address and TCP
        port numbers in the data portion of the packet, and these
        present more of a problem.

        ICMP error reports return part of the faulty datagram, and
        that part must be re-translated and the checksums recalculated
        if the process is to remain completely invisible to the user.

        Certain FTP transactions convey an IP address and port number,
        expressed in ASCII, in the data.  NAT must look for these and
        change them.  Besides being a non-trivial operation, the
        problem with this is that the translated addresses may occupy
        a different amount of space when expressed in ASCII, so NAT
        must build a new packet, and must adjust the TCP sequence
        numbers on every subsequent packet.

        There are other applications which similarly embed addressing
        information in the data portion of the packet, and strictly
        speaking, the TCP/IP layers must remain unaware of this
        information as it is of a higher layer.  In this respect NAT
        breaks normal layering rules.

        PAT achieves multiplexing by translating service port numbers,
        but some protocols do not use service port numbers at all, so
        these can not pass through PAT.  For example, ICMP, IPIP and
        AXIP can only pass through static NAT, whereas AXUDP and IPUDP
        can pass through PAT.

        The following protocols and traffic will pass through NAT:

           Protocol  Supported Traffic / Applications
           -------------------------------------------------
           RIP ?
           ICMP       Ping, Traceroute etc.
           AXIP       Ax25 tunnelling
           IPIP       IP tunnelling.
           UDP        AXUDP, IPUDP, DNS, TFTP
           TCP        Telnet, HTTP, SMTP, NNTP, POP, Finger, Rlogin
                      Plus any other traffic which does not use
                      TCP/IP addresses in the application data.


        Only the following protocols / traffic will pass through PAT:

           Protocol  Supported Traffic / Applications
           -------------------------------------------------
           UDP       AXUDP, IPUDP, DNS, TFTP
           TCP       Telnet, HTTP, SMTP, NNTP, POP, Finger, Rlogin
                     Plus any other traffic which does not use
                     TCP/IP addresses in the application data.



        Section 2 - Configuring NAT / PAT on Xrouter
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        The "NAT" commands are used for configuring both NAT and PAT
        on the fly. They can also be embedded in the IPROUTE.SYS or
        BOOTCMDS.SYS files to configure the system at startup.

        The following commands are available:

           NAT ADD     Adds entries to the translation table.
           NAT DROP    Deletes entries from the translation table.
           NAT LIST    Displays the translation table.

        Syntax is as follows:

        NAT ADD STATIC <localIP>[:port] <globalIP>[:port] [tcp | udp]
        NAT ADD OVERLOAD <localIP> <globalIP> <subnet_mask>

        The first form adds static NAT and PAT entries, and the second
        form is used only for adding overloaded dynamic PAT entries.

        In each case <localaddr> represents the "private" or
        "unregistered" IP address of a host on the stub network, and
        <globaladdr> represents a globally recognised or "registered"
        address.

        In the STATIC case, if port numbers are specified, TCP and UDP
        traffic matching the specified IP addresses will be translated
        ONLY if it also matches the specified ports.  If ports are not
        specified, all traffic is translated.  If the optional
        protocol is specified, only traffic of that protocol will be
        translated by that entry.

        The OVERLOAD case does not accept port numbers, and it
        requires a subnet mask to be specified.  The mask is used in
        combination with the local address to form a range of
        addresses which will be accepted for translation.  For
        example, if the local address is 192.168.0.0 and the netmask
        is 255.255.255.240, addresses 192.168.0.0 to 192.168.0.15
        inclusive will be translated.

        NAT DROP <local>[:port] [tcp | udp]

        Simple entries, i.e. those in which the protocol shows "ALL"
        and the port numbers are zero, can be removed by the form:

                "NAT DROP <localaddr>" e.g. "NAT DROP 192.168.0.2".

        If the translation table entry includes port numbers, the
        form:

           "NAT DROP <local_address>[:port]" is required, e.g.
           "NAT DROP 192.168.0.2:23".

        If the translation entry is protocol-specific, the protocol
        must be specified when removing the entry, e.g.:

           "NAT DROP 192.168.0.2 TCP".

        NAT LIST

        This command currently requires no arguments.


        Order of Entries in NAT table
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        The order of entries within the translation table is
        important, because XRouter will translate upon the first
        matching entry.  This gives you maximum flexibility to cater
        for your particular needs.  As a general rule, port-specific
        and protocol-specific entries should be declared before
        non-specific "catch-all" entries.  Overload entries can be
        declared anywhere, providing they don't inadvertently "hide"
        a static translation for the same address.

        Consider this example:

        NAT ADD STATIC    192.168.0.2:87  44.131.91.2:23  TCP
        NAT ADD STATIC    192.168.0.2     44.131.91.2
        NAT ADD OVERLOAD  192.168.0.0     44.131.91.3  255.255.255.240

        In the above example, TCP frames originating from port 87 on
        local host 192.168.0.2 will be translated by the first entry,
        to look like they originated from port 23 on global host
        44.131.91.2.

        UDP and all other TCP frames from that host will be translated
        by the second entry, which leaves the port numbers alone.
        This entry also translates "portless" protocols such as AXIP,
        ICMP, IPIP etc.

        The third entry translates any TCP or UDP frame originating
        from local hosts 192.168.0.0 to 192.168.0.15, excluding
        192.168.0.2, to look as if it originated at 44.131.91.3.

        If the second entry had been placed before the first, it would
        never have been executed, because the non-specific static
        entry would have intercepted *every" frame from 192.168.0.2. 
        If the overload entry had been placed first, it would have
        intercepted every TCP and UDP frame from local hosts 0 to 15,
        so the port specific static would never have been executed.


        Routing Table Requirements
        ~~~~~~~~~~~~~~~~~~~~~~~~~~
        In addition to the translation table entries, you must ensure
        that IP routing to the target system is correctly configured.

        Network Address Translation is applied *before* the packet is
        routed. This means that for "outbound" packets, i.e. those
        originating on the "private" subnet, routing to the "public"
        net should be defined.  For "inbound" packets, i.e. those
        originating on the public net, addressed to one of the global
        NAT addresses, the should be a routing entry which will route
        the translated address to the *private* subnet. This is best
        illustrated with an example:

        In IPROUTE.SYS....

        ROUTE ADD 44.0.0.0/8         44.131.90.6     11      d
        ROUTE ADD 192.168.0.1/32     *               14      d

        NAT ADD STATIC 192.168.0.1   44.131.91.3

        The first entry routes all outbound 44-net packets to peer
        44.131.90.6 on port 11.

        The second entry routes packets addressed to 192.168.0.1 onto
        port 14 which is the Ethernet LAN.

        The third entry translates destination address 44.131.91.3 on
        incoming packets into 192.168.0.1 before sending the packet on
        the LAN as dictated by the second entry.

        Internet Connection Sharing
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~
        If one of XRouter's ports is connected to the Internet (e.g.
        by dialup or cable modem), you may use dynamic PAT to allow
        other computers on a LAN to share the connection.  Assuming
        the computers on your LAN use addresses in the range
        192.168.0.1 to 192.168.0.255 (this is the range normally used
        by Windows), the NAT entry should look like this:

        NAT ADD OVERLOAD 192.168.0.0   0.0.0.0   255.255.255.0

        Note the special 0.0.0.0 entry, which tells XRouter to
        translate the source address on outgoing frames to the address
        of the port on which they are sent.  This is required if your
        Internet connection uses a dynamic IP address, but if your
        address is static you may insert it in place of the 0.0.0.0.

        If you don't have a DNS server on your LAN, you will need to
        set up the LAN computers to use Xrouter as their DNS.  You
        will also need to tell XRouter the address of at least one
        external DNS, either by including a "DNS=<ipaddr>" statement
        in XROUTER.CFG, or by using a "DNS ADD <ipaddr>" command.
        XRouter will then act as proxy DNS for the computers on the
        LAN.

        Summary
        ~~~~~~~
        a) Use NAT ADD... in IPROUTE.SYS to define translations.
        b) Add IP routing for the *global* NAT addresses.
        c) Use NAT... commands to display / adjust NAT on the fly.
        d) Report problems to me.


        References:
        ~~~~~~~~~~~
        RFC791  - Internet Protocol
        RFC792  - Internet Control Message protocol
        RFC793  - Transmission Control Protocol
        RFC1631 - The IP Network Address Translator
        RFC1700 - Assigned Numbers
        RFC1918 - Address Allocation for Private Intranets

SEE ALSO
        NAT(1)         -- NAT Commands
        IPROUTE.SYS(8) -- IP Routing / Configuration File

NAT(9)                     END OF DOCUMENT
