NCMP(9)                 XROUTER REFERENCE MANUAL            25/10/2023

NAME
        NCMP -- NetRom Control Message Protocol.

SYNOPSIS
        NCMP has been implemented in XRouter since July 2001. It is
        an extension to the NET/ROM protocol, facilitating extra
        tools for network administration, such as network probing
        and unknown route reporting.  It was described in Packet
        White Paper PWP106, most of which is reproduced below.

INTRODUCTION
        The Netrom Control Message Protocol is part of ISO Layer 3,
        and sits just above the routing sub-layer. It is intended to
        be transparently routable by any NET/ROM node, whether or not
        that node implements the protocol.

        To that end it uses NET/ROM "protocol extension" packets,
        which should (in theory) be routed "as-is" by any node which
        doesn't understand them.

PACKET STRUCTURE
        NCMP datagrams consist of a normal Layer 3 NET/ROM header,
        followed by the NCMP header, which may in some cases be
        followed an optional NCMP payload.

        The NCMP header is of variable length, and its first 5 bytes
        occupy the space normally used by a NET/ROM layer 4 header,
        as depicted in the diagram below:

                |<------------- NCMP Header ----------->| 
         -----------------------------------------------------------
        | L3hdr | Fam | Prot | Type | Code | 00 | (opt) | (Payload) |
         -----------------------------------------------------------

        Field  Bytes  Description
        --------------------------------------------------------
        L3hdr    15   NET/ROM Layer 3 Header
        Fam       1   Protocol Family = NET/ROM = 0x0f 
        Prot      1   Protocol = NCMP = 0x00
        Type      1   Type of NCMP packet (see below)
        Code      1   Usage depends on "type".
        Opt      var  Additional fields present in some types only
        Payload  var  Optional payload present in some types only

        The upper 4 bits of the TYPE are reserved for future
        expansion, and are set to zero in this version. The lower 4
        bits encode the packet type as follows:

            Type  Purpose
            ----------------------------------- 
             0    Probe Request
             1    Probe Reply
             2    Echo Request
             3    Echo Reply
             4    Routing Information Unicast
             5    Destination Unreachable

PACKET TYPES
        The following diagrams omit the L3 header for clarity:

        Type 0: Probe Request

             -------------------------------------------------
            | 0F | 00 | Type=0 | TTL | 00 | Tick(h) | Tick(l) |  
             -------------------------------------------------

            "TTL" is a Time To Live, limiting the no. of hops the
            probe may propagate. This value is also copied into the
            L3 TTL field. 

            "Tick" is a 16 bit tick counter, sent high octet first.
             This is returned unmodified by the responder, and used
            to calculate the Round Trip Time (RTT). 

            A node which responds to a probe request must return the
            whole datagram (including any additional fields not
            specified above), after changing the NCMP type from 0 to
            1 and inserting the TTL from the L3 header into the NCMP
            TTL field. 


        Type 1: Probe Reply

             -------------------------------------------------
            | 0F | 00 | Type=1 | TTL | 00 | Tick(h) | Tick(l) |  
             -------------------------------------------------

            "TTL" is the TTL from the L3 header of the rcvd probe. 

            "Tick" is the 16 bit tick count from the probe datagram 


        Type 2: Echo Request

             ------------------------------------------------------
            | 0F | 00 | Type=2 | TTL | 00 | ID | Seq | Opt payload |  
            -------------------------------------------------------

            "TTL" is the initial Layer 3 TTL
 
            "ID" is a unique 16 bit identifier, sent high octet
            first, allowing the originator to match responses with
            the requests. 

            "Seq" is a 16 bit sequence number, sent high octet first.
             Usually carries a timestamp, allowing the RTT to be
             computed. 


        Type 3: Echo Reply

            -------------------------------------------------------
            | 0F | 00 | Type=3 | TTL | 00 | ID | Seq | Opt payload |  
            -------------------------------------------------------

            "TTL" is the TTL from the L3 header of the received
            request. 

            The ID, SEQ and Payload fields must be returned
            unmodified.


        Type 4: Routing Information Unicast

             -----------------------------------------------
            | 0F | 00 | Type=4 | xx | 00  |    INP3 Data    |
             -----------------------------------------------

            "xx" = unused field


        Type 5: Destination Unreachable

             -----------------------------------------------
            | 0F | 00 | Type=5 | Code | 00  | Returned Data |
             -----------------------------------------------

            "Returned Data" is the first 28 octets of the unrouted
            datagram.  

            "Code" is as follows:

            Code Meaning           Explanation
            ---------------------------------------------------------
             0   Host Unknown      The router does not know the
                                   destination node.
  
             1   Host Unreachable  The destination node is known, but
                                   there are no viable routes at this
                                   time, due to obsolescence or link
                                   failure. 
 
             2   Net Unreachable   The number of hops to the target
                                   system is more than the remaining
                                   Time To Live.
 
             3   Proto Unreachable The destination node does not know
                                   how to handle the requested
                                   protocol.
  
             4   Service Unreach   The requested service is not
                                   implemented at the destination
                                   node.
  
             5   TTL Exceeded      The datagram could not be routed
                                   any further because its Layer 3
                                   Time to Live reached zero.
  
             6   Frag Required     The datagram is too large for the
                                   outgoing link, and the link does
                                   not support fragmentation.
 
             7   Source Quench     The datagram could not be handled
                                   at this time due to insufficient
                                   resources. This situation is
                                   temporary. Upon receipt of this
                                   message, the sender should reduce
                                   the sending rate.  

PROBES
        Probe datagrams are intended for "peer discovery". In this
        context, PEER means another NCMP-capable node.  At this time,
        only XRouters are NCMP-capable, but wider adoption would be
        desirable.

        Probes are currently dispatched with an initial TTL of 6, to
        nodes with a quality of 20 or more and a one way trip time
        below 1 minute.  These figures are likely to be revised down
        in future.  If no reply is received, the probe interval
        increases.

        Upon receipt of a probe, no matter whom it is addresed to,
        an NCMP peer returns it to the sender. Thus only the nearest
        peers are discovered.

INFORMATION EXCHANGE
        The purpose of peer discovery is to facilitate the transfer
        of additional network-related information across a legacy
        network, most of which which doesn't, and probably never
        will, embrace INP3.

        Such information may include a node's position, town,
        software type and version, contact details, Amprnet IP
        address, available services and so on. These things make
        Packet Radio more interesting.

        Once a peer had been identified, XRouters are able to
        exchange INP3 data "tunneled" inside NCMP type 4 datagrams,
        even if the intervening nodes are not INP3-capable.

        A consequence of this exchange is to allow expansion of, and
        experimentation with, INP3-like options, without breaking the
        existing INP3 protocol.  When proven, such extensions could
        be incorporated into the "official" INP3 standard if there
        was agreement.

ECHO REQUESTS
        Echo requests are intended for testing the network, and are
        invoked using XRouter's NPING (Netrom Ping) and NTRACERT
        (Netrom Traceroute) commands.

SUPERVISORY
        "Destination unreachable" messages are intended to improve
        the user experience, by quickly reporting network problems,
        instead of leaving the user  waiting for a reply that will
        never come.

        For instance, if the user tries to connect to a node that is
        in the nodes table but no longer has a viable end-to-end
        path, one of the intervening nodes should quickly return a
        "destination unreachable" message, and the user would be
        informed.  Without this, the user could typically wait six
        minutes (L4T1 * L4RETRIES) for a "Connect failed" response.

        With the exception of echo and probe, NCMP datagrams are
        never sent in response to NCMP.

SEE ALSO
        NPING(1)    -- Send NetRom Echo Request(s).
        NTRACERT(1) -- NetRom TraceRoute.
        PEERS(1)    -- Show Nearest NCMP-capable nodes.
        INP3(9)     -- Inter-Node Protocol 3.

NCMP(9)                      END OF DOCUMENT
