NDISXPKT(9)             XROUTER REFERENCE MANUAL            17/10/2023

NAME
        NDISXPKT -- NDIS Driver for XRouter (XR32 only).

DESCRIPTION
        NdisXpkt is an optional kernal-mode driver which allows XR32
        to share an Ethernet NIC with Windows, and to have its own
        completely independent IP address.

        The driver was written for XR32 in 2006 by Anthony Martin
        M1FDE, sadly now silent key.

        Unfortunately, it can only be used with Windows 2000 and
        Windows XP.


        Do I Need NdisXpkt?
        ~~~~~~~~~~~~~~~~~~~

        The NdisXpkt driver is only required if you wish to share an
        Ethernet NIC with Windows.  XR32 will work without it, but you
        will not have the full range of XR32's functionality.

        Without NdisXpkt XR32 is not able to:

            - Have its own Ethernet LAN IP address
            - Route "raw" IP via the Ethernet NIC.
            - Trace any raw IP activity via Ethernet NIC.
            - Use IPEncap encapsulation via Ethernet NIC.

        If you don't need any of the above, you don't need NdisXpkt.


        Explanation
        ~~~~~~~~~~~

        Without the NdisXpkt driver, XR32 is forced to use facilities
        provided by the Windows TCP/IP stack.  Those facilities are
        limited, and in some cases are deliberately crippled by
        Microsoft.  For example, later versions of Windows XP block
        the use of IPENCAP (protocol number 4). 

        Since no-one likes having to install and load drivers, the
        majority of sysops now tend to use XR32 without NdisXpkt.
        However this is a **basic** mode, with limited facilities,
        compared to the "full" (NdisXpkt) mode. It was only intended
        as a stop-gap measure, until a 64-bit driver could be written. 

        In basic mode, XR32 can originate and terminate all the common
        higher-level protocols (TCP, UDP, ICMP etc.), but cannot
        handle datagrams via the *Ethernet* NIC at the raw IP layer
        (IP via SLIP, PPP or IP-over-AX25 connections are not
        restricted however).  This means that XR32 cannot act as an
        IP router for datagrams to or from the LAN, unless those
        datagrams are encapsulated.  And it cannot trace IP headers
        to/from the LAN, although it is able to trace the "inner" IP
        headers of encapsulated datagrams.

        If you are using Win2000 or WinXp, and wish to install
        NdisXpkt, please read on...


        Installing NdisXpkt
        ~~~~~~~~~~~~~~~~~~~

        Before you can use NdisXpkt, it must be installed and started.

        NdisXpkt comes in two flavours, one for Windows 2000 and one
        for Windows XP.  Install only the one to match your operating
        system. The distribution package contains both, in separate
        directories named "Windows 2000" and "Windows XP".

        There are detailed installation instructions with screenshots
        in the INSTALL.HTM document of the NdisXpkt package.  They are
        summarised here:

        a) To install drivers, you need to log in using an account
           with Administrator priviledges.

        b) Extract the files from the .zip archive into a temporary
           directory on your hard drive.  You can remove this
           directory when you've finished installing.  Remember where
           you put them - you'll need them later.

        c) Open the control panel and double-click "Network
           Connections".

        d) You may only have one or two network connections in the
           lower part of the pane. Select one of the network
           connections.  It doesn't matter which you choose, a new
           driver will bind itself with all of them.  If you don't
           have any networks in the lower pane, you need to install
           one.  Either a network card, a USB network adapter, or a
           wireless LAN.  This driver can't be used without one.

        e) Hold the right mouse button and select "Properties" in the
           menu that appears.

        f) This window shows the different protocols that are bound
           to this network device.  We want to install something, so
           click the button marked "Install..."

        g) On the dialog that appears, select "Protocol" and click
           "Add".

        h) You don't want any of the standard choices, so click
           "Have Disk".  The "Install From Disk" dialog should appear. 

        i) Click "Browse" and navigate to the folder where you
           unzipped the files.  It will only show you .inf files.
           When you've found "ndispkt.inf", select it and click
           "Open", then "OK".

        j) Digital signing is not required for NDIS drivers, so click
           OK to install.

        k) The LAN connection properties box should now show
           "NdisXpkt" in the list.

        l) Click "Close" and you're done.

 
        Uninstalling NdisXpkt
        ~~~~~~~~~~~~~~~~~~~~~
 
        a) Make sure XR32 is not running, otherwise the system may
           not allow the driver to be stopped and uninstalled.

        b) Proceed as above until you reach the network connections
           properties box.

        c) Select the NdisXpkt protocol in the scrollable list.

        d) Click "Uninstall".  Windows reminds you that uninstalling
           removes it from all network ports.

        e) Click "Yes".  At this point the protocol should disappear
           from the list.

        f) Click "Close".
 

        Starting NdisXpkt
        ~~~~~~~~~~~~~~~~~

        To start the driver manually, open a command window and type:

                net start NdisXpkt

        At which point you should see the response:
 
            "The NdisXpkt service was started successfully".

        Note that the driver name is case sensitive and must be typed
        EXACTLY as above.  If you type it any other way, the driver
        will start but will not be available to XR32.

        NdisXpkt only needs to be started once per session.  You only
        need to start it again if you restart the operating system.
        It is hoped to automate the startup in future versions of
        XR32.

        In the meantime, you should be able to start NdisXpkt and
        XR32 using a batch file containing the following instructions:

            CD \MyProgs\XR32    <-- or wherever your XR32 is
            net start NdisXpkt
            XR32

        The batch file can be created using Notepad and saved as
        "STARTXR32.BAT" or something like that.  Test it to make sure
        it works.  It may need a short delay between "net start" and
        "XR32" to allow time for the NdisXpkt service to start.  A 4
        second delay can be achieved by insterting "Ping localhost"

        When you are sure that the batch file is working, drag it
        (or a shortcut to it) into Start Menu\Programs\Startup, and
        it should execute when Windows boots.


        Configuring an NdisXpkt INTERFACE
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        XR32 interfaces to NdisXpkt driver via an EXTERNAL interface,
        which is declared in XR32.CFG as follows:

            INTERFACE=1
                TYPE=EXTERNAL        ; External device driver
                ID=Ethernet LAN
                PROTOCOL=ETHER
                MTU=1064
                ETHADDR=00:07:95:fa:d9:3b
            ENDINTERFACE

        Note that the ETHADDR is mandatory and must match the MAC
        address used by the chosen NIC.  To find your NIC's MAC
        address, open a command window and type

            IPCONFIG /ALL

        then look for "Physical address", e.g.

            Ethernet adapter Local Area Connection:
            Physical Address. . . : 00-07-95-FA-D9-3B

        Alternatively, type "ROUTE PRINT" and look for the name of
        the NIC in the list, e.g.

            Interface List
            0x1 ....................... MS TCP Loopback interface
            0x2 ...00 07 95 fa d9 3b .. SiS 900 PCI Fast Ethernet 

        As you can see, there are several different ways of depicting
        a MAC / physical / Ethernet address.  XR32 requires the use of
        colons ':' between the 6 pairs of characters.


        Configuring a PORT
        ~~~~~~~~~~~~~~~~~~

        The Ethernet port is declared like this:

           PORT=1
                ID=Ethernet
                INTERFACENUM=1
                IPADDRESS=192.168.0.2
                NETMASK=255.255.255.0
                etc...

        Make sure you choose a different IP address to the one
        Windows is using!

        Note: The use of interface type EXTERNAL for NdisXpkt is a
              temporary measure, liable to change in future.

SEE ALSO
        IP-STACKS(6) -- TCP/IP Stacks in XR32
        MPORT(1)    -- Set port to monitor

NDISXPKT(9)                 END OF DOCUMENT
