NETMASK(1)            XROUTER REFERENCE MANUAL               25/9/2023

COMMAND
        NETMASK -- Display / Set Port NETMASK.

SYNOPSIS
        NE[tmask] <port> [value]

AVAILABILITY
        This command is sysop-only.

DESCRIPTION
        This command allows the NETMASK for the specified port to be
        displayed or changed.

        The NETMASK is used together with the port IPADDRESS to
        specify the range of IP addresses that are on the same
        physical network segment as XRouter. If XRouter sees any
        datagrams with a destination address within that range, and
        not addressed to itself, it will not attempt to route them.

        For example, if the NDISXPKT driver is being used, XRouter
        and Windows will have different IP addresses, but will share
        the same Ethernet address. Thus both XRouter and Window "see"
        the same datagrams. Without a suitable NETMASK value, XRouter
        would attempt to route any datagram not addressed to itself,
        which means it would attempt to route any datagrams that are
        addressed to the Windows IP address.

        The netmask is specified in dotted-quad form, for example
        "255.255.255.0". Any non-zero bit within the netmask
        specifies that the corresponding bit in the IP address should
        be non-zero. Any zero bit specifies that the corresponding
        bit in the IP address may be zero or one. e.g. if the port IP
        address is "192.168.0.11", and the netmask is "255.255.255.0",
        XRouter will process datagrams addressed to "192.168.0.11" but
        will ignore datagrams addressed to any other 192.168.0.x
        destination (where x represents a number between 0 and 255).

        The default value for NETMASK is "0.0.0.0", which disables the
        function. 

        The minimum abbreviation for this command is "NE".

OPTIONS
        If a single numeric argument is supplied, and it is a valid
        port number, the current NETMASK for that port number is
        displayed.

        If two numeric arguments are supplied, the first specifies a 
        port number and the second specifies a new NETMASK for that
        port.

EXAMPLES
        NET 1                 - Display current NETMASK for port 1.
        NET 2 255.255.255.0   - Set port 2 NETMASK to "255.255.255.0"

SEE ALSO
        IPADDRESS(1) -- Display / Set Port IP Address.
        NETMASK(7)   -- Subnet Mask Directive.

NETMASK(1)                     END OF DOCUMENT
