NFTP-SRV(9)             XROUTER REFERENCE MANUAL              7/9/2023

NAME
        NFTP-SRV -- Netrom File Transfer Protocol Server 

DESCRIPTION
        NFTP (Netrom File Transfer Protocol) is basically a form of
        FTP over NetRom. It uses fairly standard FTP server commands,
        but unlike FTP, in its simplest form it shares a single
        stream for both commands and data.

        NFTP uses NetRomX service 21, the same number as regular FTP.

        Strictly speaking, NFTP is a misnomer, because the protocol
        can be used over any reliable byte-ordered stream, be that
        AX25, NetRom or TCP.

        Although NFTP can be used by anyone, it is primarily intended
        for sysops to exchange files with each other. The protocol
        permits limited access to "public" files without login.

        The server can be accessed in one of 3 ways:

        If the source node is NetromX-capable, the user can connect
        directly to service 21 on the target node. For example,
        "C G8PZT 21". A typical response is shown: 

            c g8pzt 21
            DOTXR:VK2DOT-1} Trying G8PZT::21...
            DOTXR:VK2DOT-1} Connected to G8PZT::21 
            220 G8PZT NFTP ready - Restrictions apply

        Alternatively, the SYSOP of the source node may use the
        "NFTP <target>" command to invoke an NFTP client which
        connects to the target node. This client is not available to
        non-sysops, but there's no restriction on standalone clients.

        If the source node is *not* NetromX-capable, the user must
        connect to the target node then issue the NFTP command,
        supplying the target node's callsign as an argument.

        For example, if the user was connected to VK2DOT and wanted
        to connect to G8PZT's server, he  would issue "C G8PZT",
        wait for connection, then issue "NFTP G8PZT":

            c g8pzt
            DOTXR:VK2DOT-1} Connected to G8PZT
            nftp g8pzt
            G8PZT:KIDDER} Trying server
            220 G8PZT NFTP ready - Restrictions apply

        Once connected to the server, the HELP command reveals the
        available commands and their syntax:

            help
            211-Cmds: ABOR CWD HELP LIST MDTM NLST NOOP
            211-Cmds: PASS PWD QUIT REST RETR STOR TYPE USER
            211-(Additional commands available after login)
            211-
            211 Use HELP <cmd> for syntax etc.

            help stor
            211-STOR      Upload file to server
            211 Syntax: STOR <size> <filename>

        Login (using USER and PASS commands) is optional, and
        intended only for sysops.

        Unlogged users are restricted to a "public" directory, which
        by default is located at FTP/public. The true location is not
        shown to users. They cannot climb out of this directory, nor
        create any directories within it. It is purely a space for
        sysops and unlogged users to place publicly accessible files,
        such as useful documents, software etc. For example:

            list
            150 OK 286
            04-19-2021  02:41AM        <DIR>         .
            06-20-2020  04:07AM        <DIR>         ..
            04-19-2021  02:41AM                49375 repeaterlist.csv
            04-19-2021  02:36AM                93162 rfc8200.txt

                     4 file(s)         150,729 bytes
                     2 dir(s)          398,048 bytes free
            226 File sent ok


        The main protocol differences between FTP and NFTP are in the
        commands and responses associated with the transfer of data,
        i.e. commands like LIST, STOR and RETR.

        When a file or directory listing is requested using LIST or
        RETR, the server replies with the line "150 OK n", where n is
        the exact filesize in bytes.

        After receiving this line, the client must treat the next
        "n" received bytes as data, to be saved or displayed. After
        sending the data, the server sends the line
        "226 File sent ok", and is ready for the next command.

        The syntax to upload a file is "STOR <bytes> <filename>",
        for example, "STOR 96507 xrpi-manual.txt". If this is
        acceptable to the server, it responds "150 OK <bytes>".

        Upon receiving this line, the client must send exactly
        <bytes> bytes of data. The server will not return to command
        mode until it has received at least the specified number of
        bytes. Any excess bytes sent by the client are discarded by
        the server. 

        Thus you can read text files directly to your monitor, and
        create them directly from your keyboard if required.

NOTE
        Service 20 is reserved for possible future use as a separate
        "data" channel.

SEE ALSO
        NFTP(1)     -- Start Netrom File Transfer Protocol Session.
        NFTP-SVC(9) -- NetRomX NFTP Service.
        SERVICES(9) -- NetRomX Standard Services.

NFTP-SRV(9)                 END OF DOCUMENT
