NFTP(1)              XROUTER REFERENCE MANUAL                 9/9/2023

COMMAND
        NFTP -- Netrom File Transfer Server / Client.

SYNOPSIS
        NF[tp] <target>

AVAILABILITY
        Client is sysop-only. Server is open to all.

DESCRIPTION
        The NFTP command invokes either the NFTP client or the NFTP
        server, depending on <target>.

        NFTP is used to exchange files with other sysops, over the 
        Netrom network.

OPTIONS
        1) If <target> is the callsign or alias of the node where the
        user is logged on, it invokes the local NFTP server at that
        node. This mode is available to non-sysops, and uses fairly
        standard FTP server commands, such as LIST, STOR, RETR etc.

        2) If <target> is the callsign, alias or amprnet IP address of
        any other node, and the user is a verified sysop, it invokes a
        client which connects to the target server.

        The client uses standard FTP client commands such as DIR, GET,
        PUT etc. Most commands may be abbreviated. The full command
        list is shown below:

          ?           abort       ascii       binary      bye
          cd          cdup        close       dir         delete
          get         hash        help        lcd         ldel
          ldir        ls          list        lmkdir      lpwd
          lrmdir      lren        lview       mkdir       modtime 
          nlist       open        put         pwd         quit 
          restart     recv        rename      rmdir       send 
          status      user        verbose     view 

        Most of these commands should be familiar to FTP users.

        Typing "HELP <cmd>" gives specific help and syntax for <cmd>
        NFTP>

NOTES
        The NFTP client has full access to the local system, so is
        available only to verified sysops. A sysop connection via
        44-net is not considered secure enough to use the client.

        The client uses a "standard" L4 connection to the server,
        rather than an "extended" (NetRomX) one. This results in a
        rather clumsy connection sequence, but allows other software
        authors to incorporate NFTP, if they so desire, without
        needing to implement L4X.  The next version of XRLin/XRPi will
        use L4X if the target node supports it, otherwise it will use
        normal L4.

        A typical usage scenario would be like this:

        Sysop ALICE is chatting with sysop BOB on XR sysop chat.
        She wants his help, because her TUN interface doesn't work.

        Bob says "send me your XROUTER.CFG and I'll have a look".

        Alice types "NFTP BOB", then "PUT XROUTER.CFG" to send it,
        informing BOB via the chatserver.

        BOB studies Alice's file, but sadly can't find the error.

        Meanwhile sysop CHARLES has downloaded the file from BOB,
        and spots the error. He corrects it and uses "NFTP ALICE",
        then "PUT XRNEW.CFG" to send it back to ALICE.

        BOB downloads the new file and is enlightened. ALICE copies it
        from FTP/public to her XRPI working directory and reboots. The
        TUN interface now works. CHARLES is a genius!

        CHARLES writes a useful HOWTO about the TUN interface, and
        uploads it to ALICE's public directory, from where DICK, EDDIE,
        FRANK etc can download it.

        No-one needed to know anyone else's email address. No-one
        needed to copy files from their node machine to an email
        machine and back. There was no need to set up accounts and
        passwords. No-one had privileged access to anyone elses
        machine. It could all be done from XRouter's console.
   
SEE ALSO
        FTP(1)      -- FTP client
        NFTP-SRV(9) -- Netrom File Transfer Protocol Server
       
NFTP(1)                  END OF DOCUMENT
