NODES(1)                XROUTER REFERENCE MANUAL             18/8/2025

COMMAND
        NODES -- Display / Modify the Nodes table.

SYNOPSIS
        N[odes] [nodecall]
        N[odes] +
        N[odes] *
        N[odes] > <qual>
        N[odes] < <qual>
        N[odes] A[dd] <call>[:alias] <via_call> <port> <qual> [!]
        N[odes] B (y) <nodecall>
        N[odes] BC[ast] <portnum | T[imes]>
        N[odes] C (allsign)
        N[odes] D[rop] <nodecall>
        N[odes] F (rames)
        N[odes] H (ops)
        N[odes] HE[lp]
        N[odes] I (paddr
        N[odes] J (BPQ)
        N[odes] N (etrom) 
        N[odes] O (bsolete)
        N[odes] P (osition)
        N[odes] Q (ueue)
        N[odes] R (tt)
        N[odes] S (tats)
        N[odes] T (imes)
        N[odes] V (ia) <nodecall>
        N[odes] X (router)

DESCRIPTION
        The NODES command is used to list the contents of the Netrom
        nodes table in a variety of diferent ways, according to the
        format of the command.

        Sysops may also use the command to add and delete nodes, and
        to trigger nodes broadcasts.

        Nodes may be listed in callsign or alias order, and wildcard
        searches may be performed on either field.

        The display may be restricted to those nodes whose NetRom
        quality is greater or lesser than a specified figure, or to
        those who are netrom-only, time-only, obsolete and so on.

        Or the sysop may choose to display only those nodes for whom
        an IP address or round trip time is known, or those who have
        frames waiting, or those who have non-zero counters.

        The command may also be used to find which nodes are routed
        via which neighbour node. 

OPTIONS
        N           List all nodes, excluding "hidden" ones
        N *         List all nodes, including hidden ones
        N +         List nodes with valid time and qual metrics
        N > <qual>  List nodes whose Quality exceeds <qual>
        N < <qual>  List nodes with Quality less than <qual>
        N <call>    List information and routes to target <call>
        N A[dd]     Add a node to the table (sysop only)
        N B <call>  List nodes advertised by neighbour <call>
        N BC <port> Trigger nodes broadcast on <port> (sysop-only)
        N BC T      Display nodes broadcast timings
        N C         List nodes by callsign instead of alias
        N D[rop]    Remove a node from the table (sysop only)
        N F         List nodes with a non-zero "Frames" count
        N H         List nodes with a non-zero Hop count
        N HE[lp]    Display subcommands and brief descriptions
        N I         List nodes which have an IP address
        N J         List nodes which might be BPQ
        N N         List nodes whose only usable metric is Netrom
        N O         List only Obsolete nodes
        N P         List nodes whose position is known
        N Q         List nodes which currently have frames queued
        N R         List nodes for whom a RTT count is known
        N S         List nodes with a position, RTT or frame count 
        N T         List nodes whose only usable metric is Trip Time
        N V <call>  List nodes for whom preferred route is via <call>
        N X         List confirmed XRouter nodes

DETAIL
        When used without arguments, this command lists all the NetRom 
        nodes (but not KA nodes) known to XRouter, except those 
        "hidden" nodes whose alias begins with the hash (#) character.

        If the argument is an asterisk (*), all nodes, including 
        "hidden" nodes will be displayed.

        If the argument is a known node call or alias (e.g. N MLVN),
        the preferred route to the specified node, and up to two
        alternative routes will be displayed. Other information, such
        as the position (in APRS format) and IP address will be
        displayed if known. The response looks like this:

            G8PZT:KIDDER} Nodes:
            Info for: MLVN:G4FPV  FR=3538  RTT=2.8  Q=0  Hop=1 {PEER}
              Pos=52.2321N 2.0213W Loc=IO82QJ Qth=Malvern
              IP=44.131.92.50/32  TCP=23
              Supports: INP3 L3ROUT NRR NCMP L4X NDP PMS XRCHAT RTCHAT
              Updated: 18/10 14:43  Confirmed: 16/10 13:23

            Routes to: MLVN:G4FPV
              Qty Obs Pt Via      Stt Hop Obs2
            > 150  5   5 G4FPV   1.22  1   4 <
              110  5   9 GB7GH
                0  4   2 G1DKI-7

        Not all the above fields may be present, and additional
        fields may be displayed if available. The following
        information may be displayed after the callsign:

            "FR"  indicates the number of level 3 frames sent to that
                  node.

            "RTT" (Round Trip Time) is a running average of the time
                  (in seconds) taken to get a response from the node.

            "Q"   is the number of Level 3 frames currently queued
                  for that destination.

            "Hop" is the number of hops to the node (if known)

            "XR"  indicates that the node is known to be an XRouter.

            "PEER" indicates that the node is the nearest XRouter
                   via the route.

            "HOST" indicates that the node has a command line and may
                   host additional services, such as BBS, PMS, CHAT
                   etc.

            "PMS" indicates that the target is a Personal Message
                  System.

            "XRCHAT" indicates that the target is an XRouter chat
                     server.

        Subsequent lines may display the following:

            Pos=       Latitude and longitude
            Loc=       Maidenhead locator code
            Qth=       Location
            IP=        Amprnet IP address (if enabled)
            TCP=       TCP port for access via amprnet
            v502y      Software version
            Updated:   Date and time last seen in a broadcast
            Confirmed: Date and time confirmed by probe response
            Supports:  Some of the supported capabilities:
                       INP3    - INP3 routing information protocol
                       L3ROUT  - NetRom layer 3 routing
                       NRR     - NetRom Record Route
                       NCMP    - NetRom Control Message Protocol
                       L4X     - Extended L4 (NetRomX)
                       NDP     - NetRom Datagram Protocol
                       PMS     - Personal Mesaage System
                       XRCHAT  - XRouter chat system
                       RTCHAT  - RoundTable chat system

        In the "Routes To" section:

            ">"   in the left-most column indicates the currently 
                  active route.

            "Qty" is the overall NetRom path quality to the node.

            "Obs" is the NetRom "obsolescence count", which shows how
                  how recently the route was heard about or used.  It
                  is usually reset to OBSINIT (usually 5) upon being
                  seen in a nodes broadcast from the neighbour node,
                  and decrements by one every time XRouter makes a
                  node broadcast (typically once per hour). If it
                  drops below OBSMIN (usually 3) the route is
                  considered to be obsolete. 

            "Pt"  is the port number for the neighbour. 

            "Via" is the neighbour node via which the target is
                  reached.

            "Stt" is "Smoothed Trip Time", which is the average
                  one-way transit time to the neighbour in seconds.
                  This field may not be present in all cases.

            "Hop" is the total no. of hops to the target via this
                  neighbour. It is one more than the number of
                  intermediate nodes. This field may not always be
                  available.

            "Obs2" is the obsolescence count for the time domain
                   information (Stt & hops) which is learned via
                   INP3. This info is maintained independently of
                   NetRom "quality" metrics. A node may have obsolete
                   quality metrics, but still have valid temporal
                   metrics.
  
            "<"   indicates the preferred route, which may differ
                  from the route actually used at that instant.

        If the requested nodecall or alias is not in the table, an 
        error message results.

        If the specified callsign or alias contains wildcards, a list
        of matching nodes will be displayed.

        "N A[add]" adds a node callsign to the table. Mandatory fields
         are <call>, <via_call>, <port> and <qual>. Optional fields
         are [alias] and lock flag [!].

        "N B <call>" displays the list of nodes "advertised" by
        <call>, i.e. those nodes the neighbour claims to be able to
        reach. This is not necessarily the same as the nodes *routed*
        via that neighbour, because some of the nodes may be
        advertised with better metrics by other neighbours.

        "N BC[ast] <port>" is a sysop-only command, which initiates a
        nodes broadcast on the specified <port>.

        "N BC[ast] T[imes]" displays the timings of nodes broadcasts
        and INP3 unicasts.

        "N C" displays nodes in callsign order instead of the standard
        alias order. If you wish the nodes to be displayed in callsign
        order by default, use SORTBYCALL=1 in XROUTER.CFG.

        "N D <call>" drops (removes) a node from the table.

        "N F" displays nodes with a non-zero "Frames" count. The frame
        count is only available for nodes with to whom XRouter has
        routed some traffic.

        "N H" lists the nodes which have a non-zero "hop" count. This
        hop count is derived from actual measurements, rather than the
        "hypothetical" count derived from INP3, and is available for
        only a few nodes at most.

        "N I" displays the nodes which have an amprnet IP address.
        In practice this list is likely to contain only XRouter and
        X(Net) nodes.

        "N J" displays the nodes which MIGHT be BPQ. This information
         is currently only available for nodes which have routed some
         traffic via XRouter.

        "N N" displays the nodes whose only usable metric is NetRom
        quality, i.e. those for whom a trip time is unknown or has
        gone obsolete.

        "N O" lists the "obsolete" nodes, i.e. those for whom all
        metrics are too "stale" to be used. These nodes are probably
        off-line or otherwise unreachable.

        "N P" lists the nodes whose position is known. In practice,
        the only nodes which curently show in this list will be
        XRouters.

        "N Q" displays the nodes which currently have frames waiting
        to be delivered to them. The queues may be the result of
        link bottlenecks, and the figure is likely to change rapidly.

        "N R" displays the nodes for whom a Round Trip Time is known.
        This is an averaged value for all connections between XRouter
        and the target node, and may differ from the current
        "hypothetical" trip time, derived from INP3 information. This
        RTT is only available for nodes which XRouter has connected
        to. 

        "N S" displays the nodes for whom some "stats" are known, i.e.
        position, Round Trip Time or frame count.

        "N T" lists the nodes whose only usable metric is Time, i.e.
        those which have a valid trip time, but for whom the NetRom
        quality is unknown or is considered obsolete.

        "N V <call> displays the nodes who would be routed via
        neighbour <call> at the current instant. This choice may
        change with time, as the metrics fluctuate.

        "N X" lists the nodes known to be XRouter. This may not show
         ancient versions of XRouter.

EXAMPLES
        N           - List nodes except those beginning with #
        N *         - List nodes including those beginning with #
        N MLVN      - Display routes to MLVN node
        N V VK2DOT  - Display nodes routed via VK2DOT
        N > 100     - Display nodes with qualities greater than 100

AVAILABILITY
        The NODES command is available to all users, but the ADD, DROP
        and BCAST <port> sub-commands are sysop-only.

NODES(1)                    END OF DOCUMENT
