;*************************** Max Width *******************************
NODESINT(7)            XROUTER REFERENCE MANUAL              25/9/2023

NAME
        NODESINTERVAL -- Nodes Broadcast Interval.

SYNOPSIS
        NODESINTERVAL=<minutes>

DESCRIPTION
        NODESINTERVAL is both a global and PORT directive, used in
        XROUTER.CFG.

        It specifies the interval, in minutes, between NetRom nodes
        broadcasts. The default is 60 minutes.

        If used in the "global" section of XROUTER.CFG, it sets the
        global NODESINTERVAL, the default for all PORTs. If used in
        a PORT block, it applies to that port only.

        Whilst the Netrom network usually works on a 60 minute nodes
        broadcast cycle, some types of software insist on a much
        smaller broadcast interval.

        It is harmful to the established network if sysops try to
        accommodate these neighbours by setting the global
        NODESINTERVAL to a smaller value, but using this keyword on 
        a per-port basis you can keep these neighbours happy without
        disrupting the rest of the Netrom network.

OPTIONS
        If you set a NODESINTERVAL=0 on a PORT, XRouter ignores
        received nodes broadcasts on that port, but will allow L3/L4
        activity if QUALITY is non-zero.

EXAMPLE
        NODESINTERVAL=10 ; 10 minues between broadcasts 
    
SEE ALSO
        NODESINT(1)    -- Display / Set NODESINTERVAL.
        PORTS(6)       -- Ports in XRouter.
        QUALITY(7)     -- NetRom Quality
        XROUTER.CFG(8) -- Main Configuration File.

NODESINT(7)                  END OF DOCUMENT
