
NTRACERT(1)             XROUTER REFERENCE MANUAL            25/10/2023

COMMAND
        NTRACERT -- NetRom TraceRoute.

SYNOPSIS
        NT[racert] <nodecall> [maxhops [maxwait(ms)]]

DESCRIPTION
        The NTRACERT commmand traces the route to a NetRom node.

        It is a diagnostic tool for displaying the route to a NetRom
        target, and measuring the transit delays of packets at each
        step along the route.

        It uses the replies from a series of NCMP (Netrom Control
        Message Protocol) echo requests to produce a list of the
        nodes that the packets have passed through.

        NCMP is only understood by XRouters at present. Therefore
        only XRouter nodes show in the trace.

        3 attempts are made at each hop, thus for each hop, 3 round
        trip times are displayed, along with the nodecall at that
        hop.

        The 3 times indicate the consistency of the route. If no
        response is received from a node within the timeout
        period, a "*" is displayed in the time field.

        The operation can be aborted by sending a blank line.

OPTIONS
        <nodecall> - Callsign or alias of the target node.

        [maxhops]  - Maximum number of hops to trace (default 30)

        [maxwait]  - Maximum number of milliseconds to wait for a
                     response from each node. Default 4000 (4 secs).

        The only mandatory parameter is <nodecall>. In order to
        specify [maxwait], [maxhops] must also be specified.

EXAMPLES                                                                                           
        NT VA2OM        - Trace to VA2OM with default parameters.
        NT G7VJA-5 10   - Trace to G7VJA-5 to a max of 10 hops.
        NT XBAL 5 20000 - Trace to XBAL, 5 hops, maxwait 20secs

AVAILABILITY
        All users.

SEE ALSO
        NCMP(9)  -- NetRom Control Message Protocol.
        NPING(1) -- Send NetRom Echo Request(s).
        NRR(1)   -- NetRom Record Route.

NTRACERT(1)                 END OF DOCUMENT
