;***************************** Max Width *****************************
PACLEN(7)              XROUTER REFERENCE MANUAL              25/9/2023

NAME
        PACLEN -- Maximum Packet Length.

SYNOPSIS
        PACLEN=n (where n is in the range 0 to 256)

DESCRIPTION
        PACLEN is both a GLOBAL and a PORT configuration directive,
        used in XROUTER.CFG.

        It specifies the maximum length of the information-bearing
        portion of frames transmitted by XRouter. 

        If used in the "global" section of XROUTER.CFG, it sets the
        default value for NetRom L3 operations. The default is 236,
        which is the largest NetRom payload that will fit in a full
        sized AX25 frame.

        If used in a PORT definition block, PACLEN applies to that
        port only, and sets the maximum payload size for AX25
        frames transmitted on that port. The default in this case is
        256. New AX25 connections "inherit" this value, but may
        adjust it dynamically if allowed to do so.  Inter-node links
        can override this inheritance and use a value specified by a
        ROUTE command or a suitable entry in XRNODES.

OPTIONS
        If the port PACLEN is set to 0, Xrouter dynamically adapts
        PACLEN (and MAXFRAME) to the link conditions, to maximise
        throughput.

EXAMPLE
        PACLEN=160   ; Allow 160 byte packets 

SEE ALSO
        MAXFRAME(7)    -- Maximum Unacked AX25 Frames.
        PACLEN(1)      -- Display / Set Paclen.
        PORTS(6)       -- Ports in XRouter.
        XROUTER.CFG(8) -- Main Configuration File.

PACLEN(7)                  END OF DOCUMENT
