PACLEN(1)              XROUTER REFERENCE MANUAL              25/9/2023

COMMAND
        PACLEN -- Display / Set global or port paclen values.

SYNOPSIS
        PA[clen] <port | 0> [value]

AVAILABILITY
        This command is sysop-only.

DESCRIPTION
        The PACLEN command allows the global and port-specific PACLEN 
        settings to be displayed and changed.  Paclen is the maximum 
        data field length within an AX25 or Netrom packet.

        The global PACLEN is specified (using PACLEN=n) in the L2
        global parameters section of the XROUTER.CFG file, and is
        the default value, used where not overriden by a port-specific
        paclen.  

        All frames originating at the router use the global or port 
        paclens specified, but Netrom frames originating at other 
        systems can not be fragmented, so we have no control over 
        them, and they may be larger than our paclen.

        If the port PACLEN is set to 0, XRouter dynamicallys adapts
        PACLEN (and MAXFRAME) to the link conditions, to maximise
        throughput.

OPTIONS
        If a single numeric argument is supplied, and it is a valid
        port number, the current paclen for that port number is 
        displayed.

        If two numeric arguments are supplied, the first specifies a 
        port number and the second specifies a new paclen value for 
        that port.

        If the first argument is zero, the PACLEN command displays
        and sets the global paclen.

EXAMPLES
        PACLEN 0         - Display global default paclen
        PACLEN 0 120     - Set default paclen to 120
        PACLEN 10        - Display current paclen for port 10
        PACLEN 10 160    - Set port 10 paclen to 160

SEE ALSO
        MAXFRAME(1)    -- Display / Set MAXFRAME.
        PACLEN(7)      -- Maximum Packet Length.
        XROUTER.CFG(8) -- Main Configuration File.

PACLEN(1)                 END OF DOCUMENT
